/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricAlarm;

public class DescribeAlarmsPublisher
implements SdkPublisher<DescribeAlarmsResponse> {
    private final CloudWatchAsyncClient client;
    private final DescribeAlarmsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAlarmsPublisher(CloudWatchAsyncClient client, DescribeAlarmsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAlarmsPublisher(CloudWatchAsyncClient client, DescribeAlarmsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAlarmsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAlarmsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<MetricAlarm> metricAlarms() {
        Function<DescribeAlarmsResponse, Iterator> getIterator = response -> {
            if (response != null && response.metricAlarms() != null) {
                return response.metricAlarms().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeAlarmsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeAlarmsPublisher resume(DescribeAlarmsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeAlarmsPublisher(this.client, (DescribeAlarmsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new DescribeAlarmsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeAlarmsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeAlarmsResponseFetcher
    implements AsyncPageFetcher<DescribeAlarmsResponse> {
        private DescribeAlarmsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmsResponse previousPage) {
            return previousPage.nextToken() != null && !SdkAutoConstructList.class.isInstance(previousPage.nextToken()) && !SdkAutoConstructMap.class.isInstance(previousPage.nextToken());
        }

        public CompletableFuture<DescribeAlarmsResponse> nextPage(DescribeAlarmsResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmsPublisher.this.client.describeAlarms(DescribeAlarmsPublisher.this.firstRequest);
            }
            return DescribeAlarmsPublisher.this.client.describeAlarms((DescribeAlarmsRequest)((Object)DescribeAlarmsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

