/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudwatch.model.MetricStat;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDataQuery
implements ToCopyableBuilder<Builder, MetricDataQuery> {
    private final String id;
    private final MetricStat metricStat;
    private final String expression;
    private final String label;
    private final Boolean returnData;

    private MetricDataQuery(BuilderImpl builder) {
        this.id = builder.id;
        this.metricStat = builder.metricStat;
        this.expression = builder.expression;
        this.label = builder.label;
        this.returnData = builder.returnData;
    }

    public String id() {
        return this.id;
    }

    public MetricStat metricStat() {
        return this.metricStat;
    }

    public String expression() {
        return this.expression;
    }

    public String label() {
        return this.label;
    }

    public Boolean returnData() {
        return this.returnData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricStat());
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataQuery)) {
            return false;
        }
        MetricDataQuery other = (MetricDataQuery)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.metricStat(), other.metricStat()) && Objects.equals(this.expression(), other.expression()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.returnData(), other.returnData());
    }

    public String toString() {
        return ToString.builder((String)"MetricDataQuery").add("Id", (Object)this.id()).add("MetricStat", (Object)this.metricStat()).add("Expression", (Object)this.expression()).add("Label", (Object)this.label()).add("ReturnData", (Object)this.returnData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "MetricStat": {
                return Optional.ofNullable(clazz.cast(this.metricStat()));
            }
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "ReturnData": {
                return Optional.ofNullable(clazz.cast(this.returnData()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private MetricStat metricStat;
        private String expression;
        private String label;
        private Boolean returnData;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataQuery model) {
            this.id(model.id);
            this.metricStat(model.metricStat);
            this.expression(model.expression);
            this.label(model.label);
            this.returnData(model.returnData);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final MetricStat.Builder getMetricStat() {
            return this.metricStat != null ? this.metricStat.toBuilder() : null;
        }

        @Override
        public final Builder metricStat(MetricStat metricStat) {
            this.metricStat = metricStat;
            return this;
        }

        public final void setMetricStat(MetricStat.BuilderImpl metricStat) {
            this.metricStat = metricStat != null ? metricStat.build() : null;
        }

        public final String getExpression() {
            return this.expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Boolean getReturnData() {
            return this.returnData;
        }

        @Override
        public final Builder returnData(Boolean returnData) {
            this.returnData = returnData;
            return this;
        }

        public final void setReturnData(Boolean returnData) {
            this.returnData = returnData;
        }

        public MetricDataQuery build() {
            return new MetricDataQuery(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricDataQuery> {
        public Builder id(String var1);

        public Builder metricStat(MetricStat var1);

        default public Builder metricStat(Consumer<MetricStat.Builder> metricStat) {
            return this.metricStat((MetricStat)((MetricStat.Builder)MetricStat.builder().applyMutation(metricStat)).build());
        }

        public Builder expression(String var1);

        public Builder label(String var1);

        public Builder returnData(Boolean var1);
    }
}

