/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;

public class StatisticSetUnmarshaller
implements Unmarshaller<StatisticSet, StaxUnmarshallerContext> {
    private static final StatisticSetUnmarshaller INSTANCE = new StatisticSetUnmarshaller();

    public StatisticSet unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        StatisticSet.Builder statisticSet = StatisticSet.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SampleCount", targetDepth)) {
                    statisticSet.sampleCount(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Sum", targetDepth)) {
                    statisticSet.sum(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Minimum", targetDepth)) {
                    statisticSet.minimum(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Maximum", targetDepth)) continue;
                statisticSet.maximum(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (StatisticSet)statisticSet.build();
    }

    public static StatisticSetUnmarshaller getInstance() {
        return INSTANCE;
    }
}

