/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;

public class DisableAlarmActionsRequestMarshaller
implements Marshaller<Request<DisableAlarmActionsRequest>, DisableAlarmActionsRequest> {
    public Request<DisableAlarmActionsRequest> marshall(DisableAlarmActionsRequest disableAlarmActionsRequest) {
        if (disableAlarmActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)disableAlarmActionsRequest, "CloudWatchClient");
        request.addParameter("Action", "DisableAlarmActions");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> alarmNamesList = disableAlarmActionsRequest.alarmNames();
        if (alarmNamesList != null) {
            if (!alarmNamesList.isEmpty()) {
                int alarmNamesListIndex = 1;
                for (String alarmNamesListValue : alarmNamesList) {
                    if (alarmNamesListValue != null) {
                        request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString((String)alarmNamesListValue));
                    }
                    ++alarmNamesListIndex;
                }
            } else {
                request.addParameter("AlarmNames", "");
            }
        }
        return request;
    }
}

