/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;

public class DescribeAlarmsRequestMarshaller
implements Marshaller<Request<DescribeAlarmsRequest>, DescribeAlarmsRequest> {
    public Request<DescribeAlarmsRequest> marshall(DescribeAlarmsRequest describeAlarmsRequest) {
        if (describeAlarmsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeAlarmsRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarms");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> alarmNamesList = describeAlarmsRequest.alarmNames();
        if (alarmNamesList != null) {
            if (!alarmNamesList.isEmpty()) {
                int alarmNamesListIndex = 1;
                for (String alarmNamesListValue : alarmNamesList) {
                    if (alarmNamesListValue != null) {
                        request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString((String)alarmNamesListValue));
                    }
                    ++alarmNamesListIndex;
                }
            } else {
                request.addParameter("AlarmNames", "");
            }
        }
        if (describeAlarmsRequest.alarmNamePrefix() != null) {
            request.addParameter("AlarmNamePrefix", StringUtils.fromString((String)describeAlarmsRequest.alarmNamePrefix()));
        }
        if (describeAlarmsRequest.stateValueString() != null) {
            request.addParameter("StateValue", StringUtils.fromString((String)describeAlarmsRequest.stateValueString()));
        }
        if (describeAlarmsRequest.actionPrefix() != null) {
            request.addParameter("ActionPrefix", StringUtils.fromString((String)describeAlarmsRequest.actionPrefix()));
        }
        if (describeAlarmsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAlarmsRequest.maxRecords()));
        }
        if (describeAlarmsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAlarmsRequest.nextToken()));
        }
        return request;
    }
}

