/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;

public class DeleteDashboardsRequestMarshaller
implements Marshaller<Request<DeleteDashboardsRequest>, DeleteDashboardsRequest> {
    public Request<DeleteDashboardsRequest> marshall(DeleteDashboardsRequest deleteDashboardsRequest) {
        if (deleteDashboardsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)deleteDashboardsRequest, "CloudWatchClient");
        request.addParameter("Action", "DeleteDashboards");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> dashboardNamesList = deleteDashboardsRequest.dashboardNames();
        if (dashboardNamesList != null) {
            if (!dashboardNamesList.isEmpty()) {
                int dashboardNamesListIndex = 1;
                for (String dashboardNamesListValue : dashboardNamesList) {
                    if (dashboardNamesListValue != null) {
                        request.addParameter("DashboardNames.member." + dashboardNamesListIndex, StringUtils.fromString((String)dashboardNamesListValue));
                    }
                    ++dashboardNamesListIndex;
                }
            } else {
                request.addParameter("DashboardNames", "");
            }
        }
        return request;
    }
}

