/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DashboardValidationMessage
implements ToCopyableBuilder<Builder, DashboardValidationMessage> {
    private final String dataPath;
    private final String message;

    private DashboardValidationMessage(BuilderImpl builder) {
        this.dataPath = builder.dataPath;
        this.message = builder.message;
    }

    public String dataPath() {
        return this.dataPath;
    }

    public String message() {
        return this.message;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardValidationMessage)) {
            return false;
        }
        DashboardValidationMessage other = (DashboardValidationMessage)obj;
        return Objects.equals(this.dataPath(), other.dataPath()) && Objects.equals(this.message(), other.message());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.dataPath() != null) {
            sb.append("DataPath: ").append(this.dataPath()).append(",");
        }
        if (this.message() != null) {
            sb.append("Message: ").append(this.message()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataPath": {
                return Optional.of(clazz.cast(this.dataPath()));
            }
            case "Message": {
                return Optional.of(clazz.cast(this.message()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String dataPath;
        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardValidationMessage model) {
            this.dataPath(model.dataPath);
            this.message(model.message);
        }

        public final String getDataPath() {
            return this.dataPath;
        }

        @Override
        public final Builder dataPath(String dataPath) {
            this.dataPath = dataPath;
            return this;
        }

        public final void setDataPath(String dataPath) {
            this.dataPath = dataPath;
        }

        public final String getMessage() {
            return this.message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        public DashboardValidationMessage build() {
            return new DashboardValidationMessage(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DashboardValidationMessage> {
        public Builder dataPath(String var1);

        public Builder message(String var1);
    }
}

