/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.time.Instant;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;

public class DescribeAlarmHistoryRequestMarshaller
implements Marshaller<Request<DescribeAlarmHistoryRequest>, DescribeAlarmHistoryRequest> {
    public Request<DescribeAlarmHistoryRequest> marshall(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        if (describeAlarmHistoryRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeAlarmHistoryRequest, "CloudWatchClient");
        request.addParameter("Action", "DescribeAlarmHistory");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeAlarmHistoryRequest.alarmName() != null) {
            request.addParameter("AlarmName", StringUtils.fromString((String)describeAlarmHistoryRequest.alarmName()));
        }
        if (describeAlarmHistoryRequest.historyItemTypeString() != null) {
            request.addParameter("HistoryItemType", StringUtils.fromString((String)describeAlarmHistoryRequest.historyItemTypeString()));
        }
        if (describeAlarmHistoryRequest.startDate() != null) {
            request.addParameter("StartDate", StringUtils.fromInstant((Instant)describeAlarmHistoryRequest.startDate()));
        }
        if (describeAlarmHistoryRequest.endDate() != null) {
            request.addParameter("EndDate", StringUtils.fromInstant((Instant)describeAlarmHistoryRequest.endDate()));
        }
        if (describeAlarmHistoryRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeAlarmHistoryRequest.maxRecords()));
        }
        if (describeAlarmHistoryRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeAlarmHistoryRequest.nextToken()));
        }
        return request;
    }
}

