/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StatisticSet
implements ToCopyableBuilder<Builder, StatisticSet> {
    private final Double sampleCount;
    private final Double sum;
    private final Double minimum;
    private final Double maximum;

    private StatisticSet(BuilderImpl builder) {
        this.sampleCount = builder.sampleCount;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
    }

    public Double sampleCount() {
        return this.sampleCount;
    }

    public Double sum() {
        return this.sum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Double maximum() {
        return this.maximum;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sampleCount() == null ? 0 : this.sampleCount().hashCode());
        hashCode = 31 * hashCode + (this.sum() == null ? 0 : this.sum().hashCode());
        hashCode = 31 * hashCode + (this.minimum() == null ? 0 : this.minimum().hashCode());
        hashCode = 31 * hashCode + (this.maximum() == null ? 0 : this.maximum().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticSet)) {
            return false;
        }
        StatisticSet other = (StatisticSet)obj;
        if (other.sampleCount() == null ^ this.sampleCount() == null) {
            return false;
        }
        if (other.sampleCount() != null && !other.sampleCount().equals(this.sampleCount())) {
            return false;
        }
        if (other.sum() == null ^ this.sum() == null) {
            return false;
        }
        if (other.sum() != null && !other.sum().equals(this.sum())) {
            return false;
        }
        if (other.minimum() == null ^ this.minimum() == null) {
            return false;
        }
        if (other.minimum() != null && !other.minimum().equals(this.minimum())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        return other.maximum() == null || other.maximum().equals(this.maximum());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sampleCount() != null) {
            sb.append("SampleCount: ").append(this.sampleCount()).append(",");
        }
        if (this.sum() != null) {
            sb.append("Sum: ").append(this.sum()).append(",");
        }
        if (this.minimum() != null) {
            sb.append("Minimum: ").append(this.minimum()).append(",");
        }
        if (this.maximum() != null) {
            sb.append("Maximum: ").append(this.maximum()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SampleCount": {
                return Optional.of(clazz.cast(this.sampleCount()));
            }
            case "Sum": {
                return Optional.of(clazz.cast(this.sum()));
            }
            case "Minimum": {
                return Optional.of(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.of(clazz.cast(this.maximum()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Double sampleCount;
        private Double sum;
        private Double minimum;
        private Double maximum;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticSet model) {
            this.sampleCount(model.sampleCount);
            this.sum(model.sum);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public StatisticSet build() {
            return new StatisticSet(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, StatisticSet> {
        public Builder sampleCount(Double var1);

        public Builder sum(Double var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);
    }
}

