/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.services.cloudwatch.model.AlarmNamesCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteAlarmsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteAlarmsRequest> {
    private final List<String> alarmNames;

    private DeleteAlarmsRequest(BuilderImpl builder) {
        this.alarmNames = builder.alarmNames;
    }

    public List<String> alarmNames() {
        return this.alarmNames;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.alarmNames() == null ? 0 : this.alarmNames().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAlarmsRequest)) {
            return false;
        }
        DeleteAlarmsRequest other = (DeleteAlarmsRequest)((Object)obj);
        if (other.alarmNames() == null ^ this.alarmNames() == null) {
            return false;
        }
        return other.alarmNames() == null || other.alarmNames().equals(this.alarmNames());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alarmNames() != null) {
            sb.append("AlarmNames: ").append(this.alarmNames()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmNames": {
                return Optional.of(clazz.cast(this.alarmNames()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> alarmNames;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAlarmsRequest model) {
            this.alarmNames(model.alarmNames);
        }

        public final Collection<String> getAlarmNames() {
            return this.alarmNames;
        }

        @Override
        public final Builder alarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder alarmNames(String ... alarmNames) {
            this.alarmNames(Arrays.asList(alarmNames));
            return this;
        }

        public final void setAlarmNames(Collection<String> alarmNames) {
            this.alarmNames = AlarmNamesCopier.copy(alarmNames);
        }

        public DeleteAlarmsRequest build() {
            return new DeleteAlarmsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteAlarmsRequest> {
        public Builder alarmNames(Collection<String> var1);

        public Builder alarmNames(String ... var1);
    }
}

