/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.services.cloudwatch.model.DatapointValueMapCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Datapoint
implements ToCopyableBuilder<Builder, Datapoint> {
    private final Instant timestamp;
    private final Double sampleCount;
    private final Double average;
    private final Double sum;
    private final Double minimum;
    private final Double maximum;
    private final String unit;
    private final Map<String, Double> extendedStatistics;

    private Datapoint(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.sampleCount = builder.sampleCount;
        this.average = builder.average;
        this.sum = builder.sum;
        this.minimum = builder.minimum;
        this.maximum = builder.maximum;
        this.unit = builder.unit;
        this.extendedStatistics = builder.extendedStatistics;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Double sampleCount() {
        return this.sampleCount;
    }

    public Double average() {
        return this.average;
    }

    public Double sum() {
        return this.sum;
    }

    public Double minimum() {
        return this.minimum;
    }

    public Double maximum() {
        return this.maximum;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitString() {
        return this.unit;
    }

    public Map<String, Double> extendedStatistics() {
        return this.extendedStatistics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.sampleCount() == null ? 0 : this.sampleCount().hashCode());
        hashCode = 31 * hashCode + (this.average() == null ? 0 : this.average().hashCode());
        hashCode = 31 * hashCode + (this.sum() == null ? 0 : this.sum().hashCode());
        hashCode = 31 * hashCode + (this.minimum() == null ? 0 : this.minimum().hashCode());
        hashCode = 31 * hashCode + (this.maximum() == null ? 0 : this.maximum().hashCode());
        hashCode = 31 * hashCode + (this.unitString() == null ? 0 : this.unitString().hashCode());
        hashCode = 31 * hashCode + (this.extendedStatistics() == null ? 0 : this.extendedStatistics().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Datapoint)) {
            return false;
        }
        Datapoint other = (Datapoint)obj;
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.sampleCount() == null ^ this.sampleCount() == null) {
            return false;
        }
        if (other.sampleCount() != null && !other.sampleCount().equals(this.sampleCount())) {
            return false;
        }
        if (other.average() == null ^ this.average() == null) {
            return false;
        }
        if (other.average() != null && !other.average().equals(this.average())) {
            return false;
        }
        if (other.sum() == null ^ this.sum() == null) {
            return false;
        }
        if (other.sum() != null && !other.sum().equals(this.sum())) {
            return false;
        }
        if (other.minimum() == null ^ this.minimum() == null) {
            return false;
        }
        if (other.minimum() != null && !other.minimum().equals(this.minimum())) {
            return false;
        }
        if (other.maximum() == null ^ this.maximum() == null) {
            return false;
        }
        if (other.maximum() != null && !other.maximum().equals(this.maximum())) {
            return false;
        }
        if (other.unitString() == null ^ this.unitString() == null) {
            return false;
        }
        if (other.unitString() != null && !other.unitString().equals(this.unitString())) {
            return false;
        }
        if (other.extendedStatistics() == null ^ this.extendedStatistics() == null) {
            return false;
        }
        return other.extendedStatistics() == null || other.extendedStatistics().equals(this.extendedStatistics());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.sampleCount() != null) {
            sb.append("SampleCount: ").append(this.sampleCount()).append(",");
        }
        if (this.average() != null) {
            sb.append("Average: ").append(this.average()).append(",");
        }
        if (this.sum() != null) {
            sb.append("Sum: ").append(this.sum()).append(",");
        }
        if (this.minimum() != null) {
            sb.append("Minimum: ").append(this.minimum()).append(",");
        }
        if (this.maximum() != null) {
            sb.append("Maximum: ").append(this.maximum()).append(",");
        }
        if (this.unitString() != null) {
            sb.append("Unit: ").append(this.unitString()).append(",");
        }
        if (this.extendedStatistics() != null) {
            sb.append("ExtendedStatistics: ").append(this.extendedStatistics()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "SampleCount": {
                return Optional.of(clazz.cast(this.sampleCount()));
            }
            case "Average": {
                return Optional.of(clazz.cast(this.average()));
            }
            case "Sum": {
                return Optional.of(clazz.cast(this.sum()));
            }
            case "Minimum": {
                return Optional.of(clazz.cast(this.minimum()));
            }
            case "Maximum": {
                return Optional.of(clazz.cast(this.maximum()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unitString()));
            }
            case "ExtendedStatistics": {
                return Optional.of(clazz.cast(this.extendedStatistics()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant timestamp;
        private Double sampleCount;
        private Double average;
        private Double sum;
        private Double minimum;
        private Double maximum;
        private String unit;
        private Map<String, Double> extendedStatistics;

        private BuilderImpl() {
        }

        private BuilderImpl(Datapoint model) {
            this.timestamp(model.timestamp);
            this.sampleCount(model.sampleCount);
            this.average(model.average);
            this.sum(model.sum);
            this.minimum(model.minimum);
            this.maximum(model.maximum);
            this.unit(model.unit);
            this.extendedStatistics(model.extendedStatistics);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Double getSampleCount() {
            return this.sampleCount;
        }

        @Override
        public final Builder sampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
            return this;
        }

        public final void setSampleCount(Double sampleCount) {
            this.sampleCount = sampleCount;
        }

        public final Double getAverage() {
            return this.average;
        }

        @Override
        public final Builder average(Double average) {
            this.average = average;
            return this;
        }

        public final void setAverage(Double average) {
            this.average = average;
        }

        public final Double getSum() {
            return this.sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getMinimum() {
            return this.minimum;
        }

        @Override
        public final Builder minimum(Double minimum) {
            this.minimum = minimum;
            return this;
        }

        public final void setMinimum(Double minimum) {
            this.minimum = minimum;
        }

        public final Double getMaximum() {
            return this.maximum;
        }

        @Override
        public final Builder maximum(Double maximum) {
            this.maximum = maximum;
            return this;
        }

        public final void setMaximum(Double maximum) {
            this.maximum = maximum;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final Map<String, Double> getExtendedStatistics() {
            return this.extendedStatistics;
        }

        @Override
        public final Builder extendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
            return this;
        }

        public final void setExtendedStatistics(Map<String, Double> extendedStatistics) {
            this.extendedStatistics = DatapointValueMapCopier.copy(extendedStatistics);
        }

        public Datapoint build() {
            return new Datapoint(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Datapoint> {
        public Builder timestamp(Instant var1);

        public Builder sampleCount(Double var1);

        public Builder average(Double var1);

        public Builder sum(Double var1);

        public Builder minimum(Double var1);

        public Builder maximum(Double var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);

        public Builder extendedStatistics(Map<String, Double> var1);
    }
}

