/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.DimensionFilter;

public class DimensionFilterUnmarshaller
implements Unmarshaller<DimensionFilter, StaxUnmarshallerContext> {
    private static DimensionFilterUnmarshaller INSTANCE;

    public DimensionFilter unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        DimensionFilter.Builder dimensionFilter = DimensionFilter.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Name", targetDepth)) {
                    dimensionFilter.name(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Value", targetDepth)) continue;
                dimensionFilter.value(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (DimensionFilter)dimensionFilter.build();
    }

    public static DimensionFilterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DimensionFilterUnmarshaller();
        }
        return INSTANCE;
    }
}

