/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.DatapointValuesCopier;
import software.amazon.awssdk.services.cloudwatch.model.MessageData;
import software.amazon.awssdk.services.cloudwatch.model.MetricDataResultMessagesCopier;
import software.amazon.awssdk.services.cloudwatch.model.StatusCode;
import software.amazon.awssdk.services.cloudwatch.model.TimestampsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetricDataResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetricDataResult> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricDataResult.getter(MetricDataResult::id)).setter(MetricDataResult.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricDataResult.getter(MetricDataResult::label)).setter(MetricDataResult.setter(Builder::label)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()}).build();
    private static final SdkField<List<Instant>> TIMESTAMPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MetricDataResult.getter(MetricDataResult::timestamps)).setter(MetricDataResult.setter(Builder::timestamps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Double>> VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MetricDataResult.getter(MetricDataResult::values)).setter(MetricDataResult.setter(Builder::values)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Values").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STATUS_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(MetricDataResult.getter(MetricDataResult::statusCodeAsString)).setter(MetricDataResult.setter(Builder::statusCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusCode").build()}).build();
    private static final SdkField<List<MessageData>> MESSAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(MetricDataResult.getter(MetricDataResult::messages)).setter(MetricDataResult.setter(Builder::messages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Messages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MessageData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, LABEL_FIELD, TIMESTAMPS_FIELD, VALUES_FIELD, STATUS_CODE_FIELD, MESSAGES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final String label;
    private final List<Instant> timestamps;
    private final List<Double> values;
    private final String statusCode;
    private final List<MessageData> messages;

    private MetricDataResult(BuilderImpl builder) {
        this.id = builder.id;
        this.label = builder.label;
        this.timestamps = builder.timestamps;
        this.values = builder.values;
        this.statusCode = builder.statusCode;
        this.messages = builder.messages;
    }

    public String id() {
        return this.id;
    }

    public String label() {
        return this.label;
    }

    public List<Instant> timestamps() {
        return this.timestamps;
    }

    public List<Double> values() {
        return this.values;
    }

    public StatusCode statusCode() {
        return StatusCode.fromValue(this.statusCode);
    }

    public String statusCodeAsString() {
        return this.statusCode;
    }

    public List<MessageData> messages() {
        return this.messages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.label());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamps());
        hashCode = 31 * hashCode + Objects.hashCode(this.values());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.messages());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDataResult)) {
            return false;
        }
        MetricDataResult other = (MetricDataResult)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.label(), other.label()) && Objects.equals(this.timestamps(), other.timestamps()) && Objects.equals(this.values(), other.values()) && Objects.equals(this.statusCodeAsString(), other.statusCodeAsString()) && Objects.equals(this.messages(), other.messages());
    }

    public String toString() {
        return ToString.builder((String)"MetricDataResult").add("Id", (Object)this.id()).add("Label", (Object)this.label()).add("Timestamps", this.timestamps()).add("Values", this.values()).add("StatusCode", (Object)this.statusCodeAsString()).add("Messages", this.messages()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Label": {
                return Optional.ofNullable(clazz.cast(this.label()));
            }
            case "Timestamps": {
                return Optional.ofNullable(clazz.cast(this.timestamps()));
            }
            case "Values": {
                return Optional.ofNullable(clazz.cast(this.values()));
            }
            case "StatusCode": {
                return Optional.ofNullable(clazz.cast(this.statusCodeAsString()));
            }
            case "Messages": {
                return Optional.ofNullable(clazz.cast(this.messages()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetricDataResult, T> g) {
        return obj -> g.apply((MetricDataResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String label;
        private List<Instant> timestamps = DefaultSdkAutoConstructList.getInstance();
        private List<Double> values = DefaultSdkAutoConstructList.getInstance();
        private String statusCode;
        private List<MessageData> messages = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDataResult model) {
            this.id(model.id);
            this.label(model.label);
            this.timestamps(model.timestamps);
            this.values(model.values);
            this.statusCode(model.statusCode);
            this.messages(model.messages);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<Instant> getTimestamps() {
            return this.timestamps;
        }

        @Override
        public final Builder timestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder timestamps(Instant ... timestamps) {
            this.timestamps(Arrays.asList(timestamps));
            return this;
        }

        public final void setTimestamps(Collection<Instant> timestamps) {
            this.timestamps = TimestampsCopier.copy(timestamps);
        }

        public final Collection<Double> getValues() {
            return this.values;
        }

        @Override
        public final Builder values(Collection<Double> values) {
            this.values = DatapointValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(Double ... values) {
            this.values(Arrays.asList(values));
            return this;
        }

        public final void setValues(Collection<Double> values) {
            this.values = DatapointValuesCopier.copy(values);
        }

        public final String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public final Builder statusCode(StatusCode statusCode) {
            this.statusCode(statusCode.toString());
            return this;
        }

        public final void setStatusCode(String statusCode) {
            this.statusCode = statusCode;
        }

        public final Collection<MessageData.Builder> getMessages() {
            return this.messages != null ? (Collection)this.messages.stream().map(MessageData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder messages(Collection<MessageData> messages) {
            this.messages = MetricDataResultMessagesCopier.copy(messages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(MessageData ... messages) {
            this.messages(Arrays.asList(messages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder messages(Consumer<MessageData.Builder> ... messages) {
            this.messages(Stream.of(messages).map(c -> (MessageData)((MessageData.Builder)MessageData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMessages(Collection<MessageData.BuilderImpl> messages) {
            this.messages = MetricDataResultMessagesCopier.copyFromBuilder(messages);
        }

        public MetricDataResult build() {
            return new MetricDataResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetricDataResult> {
        public Builder id(String var1);

        public Builder label(String var1);

        public Builder timestamps(Collection<Instant> var1);

        public Builder timestamps(Instant ... var1);

        public Builder values(Collection<Double> var1);

        public Builder values(Double ... var1);

        public Builder statusCode(String var1);

        public Builder statusCode(StatusCode var1);

        public Builder messages(Collection<MessageData> var1);

        public Builder messages(MessageData ... var1);

        public Builder messages(Consumer<MessageData.Builder> ... var1);
    }
}

