/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtraildata.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtraildata.model.AuditEventResultEntriesCopier;
import software.amazon.awssdk.services.cloudtraildata.model.AuditEventResultEntry;
import software.amazon.awssdk.services.cloudtraildata.model.CloudTrailDataResponse;
import software.amazon.awssdk.services.cloudtraildata.model.ResultErrorEntriesCopier;
import software.amazon.awssdk.services.cloudtraildata.model.ResultErrorEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutAuditEventsResponse
extends CloudTrailDataResponse
implements ToCopyableBuilder<Builder, PutAuditEventsResponse> {
    private static final SdkField<List<ResultErrorEntry>> FAILED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failed").getter(PutAuditEventsResponse.getter(PutAuditEventsResponse::failed)).setter(PutAuditEventsResponse.setter(Builder::failed)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failed").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResultErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AuditEventResultEntry>> SUCCESSFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successful").getter(PutAuditEventsResponse.getter(PutAuditEventsResponse::successful)).setter(PutAuditEventsResponse.setter(Builder::successful)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successful").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuditEventResultEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FAILED_FIELD, SUCCESSFUL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutAuditEventsResponse.memberNameToFieldInitializer();
    private final List<ResultErrorEntry> failed;
    private final List<AuditEventResultEntry> successful;

    private PutAuditEventsResponse(BuilderImpl builder) {
        super(builder);
        this.failed = builder.failed;
        this.successful = builder.successful;
    }

    public final boolean hasFailed() {
        return this.failed != null && !(this.failed instanceof SdkAutoConstructList);
    }

    public final List<ResultErrorEntry> failed() {
        return this.failed;
    }

    public final boolean hasSuccessful() {
        return this.successful != null && !(this.successful instanceof SdkAutoConstructList);
    }

    public final List<AuditEventResultEntry> successful() {
        return this.successful;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFailed() ? this.failed() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessful() ? this.successful() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutAuditEventsResponse)) {
            return false;
        }
        PutAuditEventsResponse other = (PutAuditEventsResponse)((Object)obj);
        return this.hasFailed() == other.hasFailed() && Objects.equals(this.failed(), other.failed()) && this.hasSuccessful() == other.hasSuccessful() && Objects.equals(this.successful(), other.successful());
    }

    public final String toString() {
        return ToString.builder((String)"PutAuditEventsResponse").add("Failed", this.hasFailed() ? this.failed() : null).add("Successful", this.hasSuccessful() ? this.successful() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "failed": {
                return Optional.ofNullable(clazz.cast(this.failed()));
            }
            case "successful": {
                return Optional.ofNullable(clazz.cast(this.successful()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("failed", FAILED_FIELD);
        map.put("successful", SUCCESSFUL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutAuditEventsResponse, T> g) {
        return obj -> g.apply((PutAuditEventsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailDataResponse.BuilderImpl
    implements Builder {
        private List<ResultErrorEntry> failed = DefaultSdkAutoConstructList.getInstance();
        private List<AuditEventResultEntry> successful = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutAuditEventsResponse model) {
            super(model);
            this.failed(model.failed);
            this.successful(model.successful);
        }

        public final List<ResultErrorEntry.Builder> getFailed() {
            List<ResultErrorEntry.Builder> result = ResultErrorEntriesCopier.copyToBuilder(this.failed);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFailed(Collection<ResultErrorEntry.BuilderImpl> failed) {
            this.failed = ResultErrorEntriesCopier.copyFromBuilder(failed);
        }

        @Override
        public final Builder failed(Collection<ResultErrorEntry> failed) {
            this.failed = ResultErrorEntriesCopier.copy(failed);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(ResultErrorEntry ... failed) {
            this.failed(Arrays.asList(failed));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failed(Consumer<ResultErrorEntry.Builder> ... failed) {
            this.failed(Stream.of(failed).map(c -> (ResultErrorEntry)((ResultErrorEntry.Builder)ResultErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AuditEventResultEntry.Builder> getSuccessful() {
            List<AuditEventResultEntry.Builder> result = AuditEventResultEntriesCopier.copyToBuilder(this.successful);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessful(Collection<AuditEventResultEntry.BuilderImpl> successful) {
            this.successful = AuditEventResultEntriesCopier.copyFromBuilder(successful);
        }

        @Override
        public final Builder successful(Collection<AuditEventResultEntry> successful) {
            this.successful = AuditEventResultEntriesCopier.copy(successful);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(AuditEventResultEntry ... successful) {
            this.successful(Arrays.asList(successful));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successful(Consumer<AuditEventResultEntry.Builder> ... successful) {
            this.successful(Stream.of(successful).map(c -> (AuditEventResultEntry)((AuditEventResultEntry.Builder)AuditEventResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PutAuditEventsResponse build() {
            return new PutAuditEventsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailDataResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutAuditEventsResponse> {
        public Builder failed(Collection<ResultErrorEntry> var1);

        public Builder failed(ResultErrorEntry ... var1);

        public Builder failed(Consumer<ResultErrorEntry.Builder> ... var1);

        public Builder successful(Collection<AuditEventResultEntry> var1);

        public Builder successful(AuditEventResultEntry ... var1);

        public Builder successful(Consumer<AuditEventResultEntry.Builder> ... var1);
    }
}

