/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtraildata;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataClient;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtraildata.internal.CloudTrailDataServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelInsufficientPermissionException;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtraildata.model.ChannelUnsupportedSchemaException;
import software.amazon.awssdk.services.cloudtraildata.model.CloudTrailDataException;
import software.amazon.awssdk.services.cloudtraildata.model.DuplicatedAuditEventIdException;
import software.amazon.awssdk.services.cloudtraildata.model.InvalidChannelArnException;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsRequest;
import software.amazon.awssdk.services.cloudtraildata.model.PutAuditEventsResponse;
import software.amazon.awssdk.services.cloudtraildata.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtraildata.transform.PutAuditEventsRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudTrailDataClient
implements CloudTrailDataClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudTrailDataClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final CloudTrailDataServiceClientConfiguration serviceClientConfiguration;

    protected DefaultCloudTrailDataClient(CloudTrailDataServiceClientConfiguration serviceClientConfiguration, SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.serviceClientConfiguration = serviceClientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutAuditEventsResponse putAuditEvents(PutAuditEventsRequest putAuditEventsRequest) throws ChannelInsufficientPermissionException, ChannelNotFoundException, InvalidChannelArnException, ChannelUnsupportedSchemaException, DuplicatedAuditEventIdException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailDataException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutAuditEventsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)putAuditEventsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailDataClient.resolveMetricPublishers(clientConfiguration, putAuditEventsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail Data");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAuditEvents");
            PutAuditEventsResponse putAuditEventsResponse = (PutAuditEventsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAuditEvents").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)putAuditEventsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutAuditEventsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putAuditEventsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailDataClient.lambda$putAuditEvents$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    public final String serviceName() {
        return "cloudtrail-data";
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        CloudTrailDataServiceClientConfigurationBuilder.BuilderInternal serviceConfigBuilder = CloudTrailDataServiceClientConfigurationBuilder.builder(clientConfiguration.toBuilder());
        serviceConfigBuilder.overrideConfiguration(this.serviceClientConfiguration.overrideConfiguration());
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient((SdkServiceClientConfiguration.Builder)serviceConfigBuilder);
        }
        return serviceConfigBuilder.buildSdkClientConfiguration();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudTrailDataException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("ChannelUnsupportedSchema").exceptionBuilderSupplier(ChannelUnsupportedSchemaException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelNotFound").exceptionBuilderSupplier(ChannelNotFoundException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("DuplicatedAuditEventId").exceptionBuilderSupplier(DuplicatedAuditEventIdException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ChannelInsufficientPermission").exceptionBuilderSupplier(ChannelInsufficientPermissionException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidChannelARN").exceptionBuilderSupplier(InvalidChannelArnException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
    }

    @Override
    public final CloudTrailDataServiceClientConfiguration serviceClientConfiguration() {
        return this.serviceClientConfiguration;
    }

    public void close() {
        this.clientHandler.close();
    }

    private static /* synthetic */ void lambda$putAuditEvents$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

