/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtraildata;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataClient;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataClientBuilder;
import software.amazon.awssdk.services.cloudtraildata.CloudTrailDataServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtraildata.DefaultCloudTrailDataBaseClientBuilder;
import software.amazon.awssdk.services.cloudtraildata.DefaultCloudTrailDataClient;
import software.amazon.awssdk.services.cloudtraildata.endpoints.CloudTrailDataEndpointProvider;

@SdkInternalApi
final class DefaultCloudTrailDataClientBuilder
extends DefaultCloudTrailDataBaseClientBuilder<CloudTrailDataClientBuilder, CloudTrailDataClient>
implements CloudTrailDataClientBuilder {
    DefaultCloudTrailDataClientBuilder() {
    }

    @Override
    public DefaultCloudTrailDataClientBuilder endpointProvider(CloudTrailDataEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final CloudTrailDataClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultCloudTrailDataClientBuilder.validateClientOptions(clientConfiguration);
        URI endpointOverride = null;
        if (clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        CloudTrailDataServiceClientConfiguration serviceClientConfiguration = CloudTrailDataServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).build();
        return new DefaultCloudTrailDataClient(serviceClientConfiguration, clientConfiguration);
    }
}

