/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventConfigurationRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, GetEventConfigurationRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrailName").getter(GetEventConfigurationRequest.getter(GetEventConfigurationRequest::trailName)).setter(GetEventConfigurationRequest.setter(Builder::trailName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStore").getter(GetEventConfigurationRequest.getter(GetEventConfigurationRequest::eventDataStore)).setter(GetEventConfigurationRequest.setter(Builder::eventDataStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD, EVENT_DATA_STORE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEventConfigurationRequest.memberNameToFieldInitializer();
    private final String trailName;
    private final String eventDataStore;

    private GetEventConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.eventDataStore = builder.eventDataStore;
    }

    public final String trailName() {
        return this.trailName;
    }

    public final String eventDataStore() {
        return this.eventDataStore;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStore());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventConfigurationRequest)) {
            return false;
        }
        GetEventConfigurationRequest other = (GetEventConfigurationRequest)((Object)obj);
        return Objects.equals(this.trailName(), other.trailName()) && Objects.equals(this.eventDataStore(), other.eventDataStore());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventConfigurationRequest").add("TrailName", (Object)this.trailName()).add("EventDataStore", (Object)this.eventDataStore()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailName": {
                return Optional.ofNullable(clazz.cast(this.trailName()));
            }
            case "EventDataStore": {
                return Optional.ofNullable(clazz.cast(this.eventDataStore()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("TrailName", TRAIL_NAME_FIELD);
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEventConfigurationRequest, T> g) {
        return obj -> g.apply((GetEventConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String trailName;
        private String eventDataStore;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventConfigurationRequest model) {
            super(model);
            this.trailName(model.trailName);
            this.eventDataStore(model.eventDataStore);
        }

        public final String getTrailName() {
            return this.trailName;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final String getEventDataStore() {
            return this.eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetEventConfigurationRequest build() {
            return new GetEventConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventConfigurationRequest> {
        public Builder trailName(String var1);

        public Builder eventDataStore(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

