/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.OperatorTargetListCopier;
import software.amazon.awssdk.services.cloudtrail.model.Type;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContextKeySelector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContextKeySelector> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(ContextKeySelector.getter(ContextKeySelector::typeAsString)).setter(ContextKeySelector.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> EQUALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Equals").getter(ContextKeySelector.getter(ContextKeySelector::equalsValue)).setter(ContextKeySelector.setter(Builder::equalsValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Equals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, EQUALS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContextKeySelector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<String> equals;

    private ContextKeySelector(BuilderImpl builder) {
        this.type = builder.type;
        this.equals = builder.equals;
    }

    public final Type type() {
        return Type.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasEqualsValue() {
        return this.equals != null && !(this.equals instanceof SdkAutoConstructList);
    }

    public final List<String> equalsValue() {
        return this.equals;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEqualsValue() ? this.equalsValue() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContextKeySelector)) {
            return false;
        }
        ContextKeySelector other = (ContextKeySelector)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasEqualsValue() == other.hasEqualsValue() && Objects.equals(this.equalsValue(), other.equalsValue());
    }

    public final String toString() {
        return ToString.builder((String)"ContextKeySelector").add("Type", (Object)this.typeAsString()).add("Equals", this.hasEqualsValue() ? this.equalsValue() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Equals": {
                return Optional.ofNullable(clazz.cast(this.equalsValue()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Type", TYPE_FIELD);
        map.put("Equals", EQUALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContextKeySelector, T> g) {
        return obj -> g.apply((ContextKeySelector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<String> equals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContextKeySelector model) {
            this.type(model.type);
            this.equalsValue(model.equals);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getEqualsValue() {
            if (this.equals instanceof SdkAutoConstructList) {
                return null;
            }
            return this.equals;
        }

        public final void setEqualsValue(Collection<String> equals) {
            this.equals = OperatorTargetListCopier.copy(equals);
        }

        @Override
        public final Builder equalsValue(Collection<String> equals) {
            this.equals = OperatorTargetListCopier.copy(equals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder equalsValue(String ... equals) {
            this.equalsValue(Arrays.asList(equals));
            return this;
        }

        public ContextKeySelector build() {
            return new ContextKeySelector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContextKeySelector> {
        public Builder type(String var1);

        public Builder type(Type var1);

        public Builder equalsValue(Collection<String> var1);

        public Builder equalsValue(String ... var1);
    }
}

