/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.ImportsListCopier;
import software.amazon.awssdk.services.cloudtrail.model.ImportsListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImportsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, ListImportsResponse> {
    private static final SdkField<List<ImportsListItem>> IMPORTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Imports").getter(ListImportsResponse.getter(ListImportsResponse::imports)).setter(ListImportsResponse.setter(Builder::imports)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Imports").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImportsListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListImportsResponse.getter(ListImportsResponse::nextToken)).setter(ListImportsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMPORTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListImportsResponse.memberNameToFieldInitializer();
    private final List<ImportsListItem> imports;
    private final String nextToken;

    private ListImportsResponse(BuilderImpl builder) {
        super(builder);
        this.imports = builder.imports;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImports() {
        return this.imports != null && !(this.imports instanceof SdkAutoConstructList);
    }

    public final List<ImportsListItem> imports() {
        return this.imports;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImports() ? this.imports() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImportsResponse)) {
            return false;
        }
        ListImportsResponse other = (ListImportsResponse)((Object)obj);
        return this.hasImports() == other.hasImports() && Objects.equals(this.imports(), other.imports()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImportsResponse").add("Imports", this.hasImports() ? this.imports() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Imports": {
                return Optional.ofNullable(clazz.cast(this.imports()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Imports", IMPORTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImportsResponse, T> g) {
        return obj -> g.apply((ListImportsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<ImportsListItem> imports = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImportsResponse model) {
            super(model);
            this.imports(model.imports);
            this.nextToken(model.nextToken);
        }

        public final List<ImportsListItem.Builder> getImports() {
            List<ImportsListItem.Builder> result = ImportsListCopier.copyToBuilder(this.imports);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImports(Collection<ImportsListItem.BuilderImpl> imports) {
            this.imports = ImportsListCopier.copyFromBuilder(imports);
        }

        @Override
        public final Builder imports(Collection<ImportsListItem> imports) {
            this.imports = ImportsListCopier.copy(imports);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(ImportsListItem ... imports) {
            this.imports(Arrays.asList(imports));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imports(Consumer<ImportsListItem.Builder> ... imports) {
            this.imports(Stream.of(imports).map(c -> (ImportsListItem)((ImportsListItem.Builder)ImportsListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImportsResponse build() {
            return new ListImportsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImportsResponse> {
        public Builder imports(Collection<ImportsListItem> var1);

        public Builder imports(ImportsListItem ... var1);

        public Builder imports(Consumer<ImportsListItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

