/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SdkServiceClientConfiguration;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.CloudTrailServiceClientConfiguration;
import software.amazon.awssdk.services.cloudtrail.internal.CloudTrailServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.cloudtrail.model.AccessDeniedException;
import software.amazon.awssdk.services.cloudtrail.model.AccountHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.AccountNotRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AccountRegisteredException;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.AddTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.CancelQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.CannotDelegateManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelExistsForEdsException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ChannelNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailAccessNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailException;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailInvalidClientTokenIdException;
import software.amazon.awssdk.services.cloudtrail.model.CloudWatchLogsDeliveryUnavailableException;
import software.amazon.awssdk.services.cloudtrail.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudtrail.model.ConflictException;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.CreateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DelegatedAdminAccountLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeleteTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.DeregisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.DescribeTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.DisableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationRequest;
import software.amazon.awssdk.services.cloudtrail.model.EnableFederationResponse;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreArnInvalidException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreFederationEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreHasOngoingImportException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreMaxLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.EventDataStoreTerminationProtectedException;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.GenerateQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.GenerateResponseException;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventConfigurationRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventConfigurationResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetTrailStatusResponse;
import software.amazon.awssdk.services.cloudtrail.model.ImportNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveEventDataStoreException;
import software.amazon.awssdk.services.cloudtrail.model.InactiveQueryException;
import software.amazon.awssdk.services.cloudtrail.model.InsightNotEnabledException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientDependencyServiceAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientEncryptionPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientIamAccessPermissionException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientS3BucketPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InsufficientSnsTopicPolicyException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsLogGroupArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidCloudWatchLogsRoleArnException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidDateRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreCategoryException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventDataStoreStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidEventSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidHomeRegionException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidImportSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidInsightSelectorsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidKmsKeyIdException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidLookupAttributesException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidMaxResultsException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatementException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidQueryStatusException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3BucketNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidS3PrefixException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSnsTopicNameException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidSourceException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTagParameterException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTimeRangeException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTokenException;
import software.amazon.awssdk.services.cloudtrail.model.InvalidTrailNameException;
import software.amazon.awssdk.services.cloudtrail.model.KmsException;
import software.amazon.awssdk.services.cloudtrail.model.KmsKeyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListChannelsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListEventDataStoresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportFailuresResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListImportsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsMetricDataResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListTrailsResponse;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsRequest;
import software.amazon.awssdk.services.cloudtrail.model.LookupEventsResponse;
import software.amazon.awssdk.services.cloudtrail.model.MaxConcurrentQueriesException;
import software.amazon.awssdk.services.cloudtrail.model.MaximumNumberOfTrailsExceededException;
import software.amazon.awssdk.services.cloudtrail.model.NoManagementAccountSlrExistsException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationManagementAccountException;
import software.amazon.awssdk.services.cloudtrail.model.NotOrganizationMasterAccountException;
import software.amazon.awssdk.services.cloudtrail.model.OperationNotPermittedException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationNotInAllFeaturesModeException;
import software.amazon.awssdk.services.cloudtrail.model.OrganizationsNotInUseException;
import software.amazon.awssdk.services.cloudtrail.model.PutEventConfigurationRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventConfigurationResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutEventSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutInsightSelectorsResponse;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyRequest;
import software.amazon.awssdk.services.cloudtrail.model.PutResourcePolicyResponse;
import software.amazon.awssdk.services.cloudtrail.model.QueryIdNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminRequest;
import software.amazon.awssdk.services.cloudtrail.model.RegisterOrganizationDelegatedAdminResponse;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsRequest;
import software.amazon.awssdk.services.cloudtrail.model.RemoveTagsResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceArnNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.ResourcePolicyNotValidException;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTypeNotSupportedException;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.RestoreEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.S3BucketDoesNotExistException;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesRequest;
import software.amazon.awssdk.services.cloudtrail.model.SearchSampleQueriesResponse;
import software.amazon.awssdk.services.cloudtrail.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartDashboardRefreshResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryRequest;
import software.amazon.awssdk.services.cloudtrail.model.StartQueryResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopEventDataStoreIngestionResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopImportRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopImportResponse;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingRequest;
import software.amazon.awssdk.services.cloudtrail.model.StopLoggingResponse;
import software.amazon.awssdk.services.cloudtrail.model.TagsLimitExceededException;
import software.amazon.awssdk.services.cloudtrail.model.ThrottlingException;
import software.amazon.awssdk.services.cloudtrail.model.TrailAlreadyExistsException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotFoundException;
import software.amazon.awssdk.services.cloudtrail.model.TrailNotProvidedException;
import software.amazon.awssdk.services.cloudtrail.model.UnsupportedOperationException;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateChannelResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateEventDataStoreResponse;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.UpdateTrailResponse;
import software.amazon.awssdk.services.cloudtrail.transform.AddTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CancelQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.CreateTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeleteTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DeregisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DescribeTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.DisableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.EnableFederationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GenerateQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetQueryResultsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.GetTrailStatusRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListChannelsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListEventDataStoresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportFailuresRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListImportsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListInsightsMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListPublicKeysRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.ListTrailsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.LookupEventsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventConfigurationRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutEventSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutInsightSelectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.PutResourcePolicyRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RegisterOrganizationDelegatedAdminRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RemoveTagsRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.RestoreEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.SearchSampleQueriesRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartDashboardRefreshRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StartQueryRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopEventDataStoreIngestionRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopImportRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.StopLoggingRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateChannelRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateEventDataStoreRequestMarshaller;
import software.amazon.awssdk.services.cloudtrail.transform.UpdateTrailRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudTrailClient
implements CloudTrailClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudTrailClient.class);
    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder().serviceProtocol(AwsServiceProtocol.AWS_JSON).build();
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudTrailClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option((ClientOption)SdkClientOption.SDK_CLIENT, (Object)this).option((ClientOption)SdkClientOption.API_METADATA, (Object)"CloudTrail#2.35.x").build();
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddTagsResponse addTags(AddTagsRequest addTagsRequest) throws ResourceNotFoundException, CloudTrailArnInvalidException, EventDataStoreArnInvalidException, ChannelArnInvalidException, ResourceTypeNotSupportedException, TagsLimitExceededException, InvalidTrailNameException, InvalidTagParameterException, InactiveEventDataStoreException, EventDataStoreNotFoundException, ChannelNotFoundException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, ConflictException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AddTagsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)addTagsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, addTagsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AddTags");
            AddTagsResponse addTagsResponse = (AddTagsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AddTags").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)addTagsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AddTagsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return addTagsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$addTags$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CancelQueryResponse cancelQuery(CancelQueryRequest cancelQueryRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InactiveQueryException, InvalidParameterException, QueryIdNotFoundException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, ConflictException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CancelQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)cancelQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, cancelQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CancelQuery");
            CancelQueryResponse cancelQueryResponse = (CancelQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CancelQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)cancelQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CancelQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return cancelQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$cancelQuery$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateChannelResponse createChannel(CreateChannelRequest createChannelRequest) throws ChannelMaxLimitExceededException, InvalidSourceException, ChannelAlreadyExistsException, EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreCategoryException, InactiveEventDataStoreException, InvalidParameterException, InvalidTagParameterException, TagsLimitExceededException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, createChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateChannel");
            CreateChannelResponse createChannelResponse = (CreateChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$createChannel$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest) throws ConflictException, InvalidTagParameterException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InsufficientEncryptionPolicyException, InvalidQueryStatementException, ServiceQuotaExceededException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, createDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDashboard");
            CreateDashboardResponse createDashboardResponse = (CreateDashboardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createDashboardRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createDashboardResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$createDashboard$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateEventDataStoreResponse createEventDataStore(CreateEventDataStoreRequest createEventDataStoreRequest) throws EventDataStoreAlreadyExistsException, EventDataStoreMaxLimitExceededException, InvalidEventSelectorsException, InvalidParameterException, InvalidTagParameterException, OperationNotPermittedException, UnsupportedOperationException, ConflictException, InsufficientEncryptionPolicyException, InvalidKmsKeyIdException, KmsKeyNotFoundException, KmsException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException, OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateEventDataStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, createEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateEventDataStore");
            CreateEventDataStoreResponse createEventDataStoreResponse = (CreateEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$createEventDataStore$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateTrailResponse createTrail(CreateTrailRequest createTrailRequest) throws MaximumNumberOfTrailsExceededException, TrailAlreadyExistsException, S3BucketDoesNotExistException, InsufficientS3BucketPolicyException, InsufficientSnsTopicPolicyException, InsufficientEncryptionPolicyException, InvalidS3BucketNameException, InvalidS3PrefixException, InvalidSnsTopicNameException, InvalidKmsKeyIdException, InvalidTrailNameException, TrailNotProvidedException, TagsLimitExceededException, InvalidParameterCombinationException, InvalidParameterException, KmsKeyNotFoundException, KmsException, InvalidCloudWatchLogsLogGroupArnException, InvalidCloudWatchLogsRoleArnException, CloudWatchLogsDeliveryUnavailableException, InvalidTagParameterException, UnsupportedOperationException, OperationNotPermittedException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException, OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, NoManagementAccountSlrExistsException, CloudTrailInvalidClientTokenIdException, ConflictException, ThrottlingException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateTrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)createTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, createTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateTrail");
            CreateTrailResponse createTrailResponse = (CreateTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)createTrailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createTrailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$createTrail$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteChannelResponse deleteChannel(DeleteChannelRequest deleteChannelRequest) throws ChannelArnInvalidException, ChannelNotFoundException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteChannel");
            DeleteChannelResponse deleteChannelResponse = (DeleteChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteChannel$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) throws ConflictException, ResourceNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDashboard");
            DeleteDashboardResponse deleteDashboardResponse = (DeleteDashboardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteDashboardRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteDashboardResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteDashboard$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteEventDataStoreResponse deleteEventDataStore(DeleteEventDataStoreRequest deleteEventDataStoreRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, EventDataStoreTerminationProtectedException, EventDataStoreHasOngoingImportException, InactiveEventDataStoreException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, ChannelExistsForEdsException, InsufficientDependencyServiceAccessPermissionException, ConflictException, EventDataStoreFederationEnabledException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteEventDataStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteEventDataStore");
            DeleteEventDataStoreResponse deleteEventDataStoreResponse = (DeleteEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteEventDataStore$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteResourcePolicyResponse deleteResourcePolicy(DeleteResourcePolicyRequest deleteResourcePolicyRequest) throws ResourceArnNotValidException, ResourceNotFoundException, ResourcePolicyNotFoundException, ResourceTypeNotSupportedException, ConflictException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteResourcePolicy");
            DeleteResourcePolicyResponse deleteResourcePolicyResponse = (DeleteResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteResourcePolicy$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteTrailResponse deleteTrail(DeleteTrailRequest deleteTrailRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, ConflictException, ThrottlingException, InvalidHomeRegionException, UnsupportedOperationException, OperationNotPermittedException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, InsufficientDependencyServiceAccessPermissionException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteTrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deleteTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deleteTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteTrail");
            DeleteTrailResponse deleteTrailResponse = (DeleteTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deleteTrailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteTrailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deleteTrail$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeregisterOrganizationDelegatedAdminResponse deregisterOrganizationDelegatedAdmin(DeregisterOrganizationDelegatedAdminRequest deregisterOrganizationDelegatedAdminRequest) throws AccountNotFoundException, AccountNotRegisteredException, CloudTrailAccessNotEnabledException, ConflictException, InsufficientDependencyServiceAccessPermissionException, InvalidParameterException, NotOrganizationManagementAccountException, OrganizationNotInAllFeaturesModeException, OrganizationsNotInUseException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeregisterOrganizationDelegatedAdminResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)deregisterOrganizationDelegatedAdminRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, deregisterOrganizationDelegatedAdminRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeregisterOrganizationDelegatedAdmin");
            DeregisterOrganizationDelegatedAdminResponse deregisterOrganizationDelegatedAdminResponse = (DeregisterOrganizationDelegatedAdminResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeregisterOrganizationDelegatedAdmin").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)deregisterOrganizationDelegatedAdminRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeregisterOrganizationDelegatedAdminRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deregisterOrganizationDelegatedAdminResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$deregisterOrganizationDelegatedAdmin$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeQueryResponse describeQuery(DescribeQueryRequest describeQueryRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InvalidParameterException, QueryIdNotFoundException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, describeQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeQuery");
            DescribeQueryResponse describeQueryResponse = (DescribeQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$describeQuery$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeTrailsResponse describeTrails(DescribeTrailsRequest describeTrailsRequest) throws UnsupportedOperationException, OperationNotPermittedException, InvalidTrailNameException, CloudTrailArnInvalidException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DescribeTrailsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)describeTrailsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, describeTrailsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeTrails");
            DescribeTrailsResponse describeTrailsResponse = (DescribeTrailsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeTrails").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)describeTrailsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeTrailsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return describeTrailsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$describeTrails$27((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisableFederationResponse disableFederation(DisableFederationRequest disableFederationRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidParameterException, InactiveEventDataStoreException, OperationNotPermittedException, UnsupportedOperationException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, ConcurrentModificationException, AccessDeniedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisableFederationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)disableFederationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, disableFederationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableFederation");
            DisableFederationResponse disableFederationResponse = (DisableFederationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableFederation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)disableFederationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisableFederationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disableFederationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$disableFederation$29((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EnableFederationResponse enableFederation(EnableFederationRequest enableFederationRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidParameterException, InactiveEventDataStoreException, OperationNotPermittedException, UnsupportedOperationException, CloudTrailAccessNotEnabledException, InsufficientDependencyServiceAccessPermissionException, NotOrganizationMasterAccountException, NoManagementAccountSlrExistsException, OrganizationsNotInUseException, OrganizationNotInAllFeaturesModeException, ConcurrentModificationException, AccessDeniedException, EventDataStoreFederationEnabledException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, EnableFederationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)enableFederationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, enableFederationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableFederation");
            EnableFederationResponse enableFederationResponse = (EnableFederationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableFederation").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)enableFederationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new EnableFederationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return enableFederationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$enableFederation$31((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GenerateQueryResponse generateQuery(GenerateQueryRequest generateQueryRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InvalidParameterException, GenerateResponseException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GenerateQueryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)generateQueryRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, generateQueryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GenerateQuery");
            GenerateQueryResponse generateQueryResponse = (GenerateQueryResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GenerateQuery").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)generateQueryRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GenerateQueryRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return generateQueryResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$generateQuery$33((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetChannelResponse getChannel(GetChannelRequest getChannelRequest) throws ChannelArnInvalidException, ChannelNotFoundException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetChannelResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getChannelRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getChannelRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetChannel");
            GetChannelResponse getChannelResponse = (GetChannelResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetChannel").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getChannelRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetChannelRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getChannelResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getChannel$35((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDashboardResponse getDashboard(GetDashboardRequest getDashboardRequest) throws ResourceNotFoundException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetDashboardResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getDashboardRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDashboard");
            GetDashboardResponse getDashboardResponse = (GetDashboardResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDashboard").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getDashboardRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetDashboardRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getDashboardResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getDashboard$37((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventConfigurationResponse getEventConfiguration(GetEventConfigurationRequest getEventConfigurationRequest) throws CloudTrailArnInvalidException, UnsupportedOperationException, OperationNotPermittedException, EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidEventDataStoreStatusException, InvalidParameterException, InvalidEventDataStoreCategoryException, NoManagementAccountSlrExistsException, InvalidParameterCombinationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventConfigurationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventConfigurationRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getEventConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventConfiguration");
            GetEventConfigurationResponse getEventConfigurationResponse = (GetEventConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventConfiguration").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getEventConfiguration$39((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventDataStoreResponse getEventDataStore(GetEventDataStoreRequest getEventDataStoreRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventDataStoreResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventDataStoreRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getEventDataStoreRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventDataStore");
            GetEventDataStoreResponse getEventDataStoreResponse = (GetEventDataStoreResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventDataStore").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventDataStoreRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventDataStoreRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventDataStoreResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getEventDataStore$41((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetEventSelectorsResponse getEventSelectors(GetEventSelectorsRequest getEventSelectorsRequest) throws TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, UnsupportedOperationException, OperationNotPermittedException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetEventSelectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getEventSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getEventSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetEventSelectors");
            GetEventSelectorsResponse getEventSelectorsResponse = (GetEventSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetEventSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getEventSelectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetEventSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getEventSelectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getEventSelectors$43((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetImportResponse getImport(GetImportRequest getImportRequest) throws ImportNotFoundException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetImportResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getImportRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getImportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetImport");
            GetImportResponse getImportResponse = (GetImportResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetImport").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getImportRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetImportRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getImportResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getImport$45((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetInsightSelectorsResponse getInsightSelectors(GetInsightSelectorsRequest getInsightSelectorsRequest) throws InvalidParameterException, InvalidParameterCombinationException, TrailNotFoundException, InvalidTrailNameException, CloudTrailArnInvalidException, UnsupportedOperationException, OperationNotPermittedException, InsightNotEnabledException, NoManagementAccountSlrExistsException, ThrottlingException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetInsightSelectorsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getInsightSelectorsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getInsightSelectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightSelectors");
            GetInsightSelectorsResponse getInsightSelectorsResponse = (GetInsightSelectorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightSelectors").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getInsightSelectorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetInsightSelectorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getInsightSelectorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getInsightSelectors$47((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetQueryResultsResponse getQueryResults(GetQueryResultsRequest getQueryResultsRequest) throws EventDataStoreArnInvalidException, EventDataStoreNotFoundException, InactiveEventDataStoreException, InvalidMaxResultsException, InvalidNextTokenException, InvalidParameterException, QueryIdNotFoundException, InsufficientEncryptionPolicyException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetQueryResultsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getQueryResultsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getQueryResultsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetQueryResults");
            GetQueryResultsResponse getQueryResultsResponse = (GetQueryResultsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetQueryResults").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getQueryResultsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetQueryResultsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getQueryResultsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getQueryResults$49((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetResourcePolicyResponse getResourcePolicy(GetResourcePolicyRequest getResourcePolicyRequest) throws ResourceArnNotValidException, ResourceNotFoundException, ResourcePolicyNotFoundException, ResourceTypeNotSupportedException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetResourcePolicyResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getResourcePolicyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getResourcePolicyRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetResourcePolicy");
            GetResourcePolicyResponse getResourcePolicyResponse = (GetResourcePolicyResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetResourcePolicy").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getResourcePolicyRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetResourcePolicyRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getResourcePolicyResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getResourcePolicy$51((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrailResponse getTrail(GetTrailRequest getTrailRequest) throws CloudTrailArnInvalidException, TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTrailRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getTrailRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrail");
            GetTrailResponse getTrailResponse = (GetTrailResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrail").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTrailRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTrailRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTrailResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getTrail$53((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetTrailStatusResponse getTrailStatus(GetTrailStatusRequest getTrailStatusRequest) throws CloudTrailArnInvalidException, TrailNotFoundException, InvalidTrailNameException, UnsupportedOperationException, OperationNotPermittedException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetTrailStatusResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)getTrailStatusRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, getTrailStatusRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetTrailStatus");
            GetTrailStatusResponse getTrailStatusResponse = (GetTrailStatusResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetTrailStatus").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)getTrailStatusRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetTrailStatusRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getTrailStatusResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$getTrailStatus$55((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListChannelsResponse listChannels(ListChannelsRequest listChannelsRequest) throws InvalidNextTokenException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListChannelsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listChannelsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listChannelsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListChannels");
            ListChannelsResponse listChannelsResponse = (ListChannelsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListChannels").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listChannelsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListChannelsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listChannelsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listChannels$57((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListDashboardsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listDashboardsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listDashboardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDashboards");
            ListDashboardsResponse listDashboardsResponse = (ListDashboardsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDashboards").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listDashboardsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDashboardsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listDashboardsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listDashboards$59((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListEventDataStoresResponse listEventDataStores(ListEventDataStoresRequest listEventDataStoresRequest) throws InvalidMaxResultsException, InvalidNextTokenException, OperationNotPermittedException, UnsupportedOperationException, NoManagementAccountSlrExistsException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListEventDataStoresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listEventDataStoresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listEventDataStoresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListEventDataStores");
            ListEventDataStoresResponse listEventDataStoresResponse = (ListEventDataStoresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListEventDataStores").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listEventDataStoresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListEventDataStoresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listEventDataStoresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listEventDataStores$61((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportFailuresResponse listImportFailures(ListImportFailuresRequest listImportFailuresRequest) throws InvalidNextTokenException, OperationNotPermittedException, UnsupportedOperationException, InvalidParameterException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportFailuresResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportFailuresRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listImportFailuresRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImportFailures");
            ListImportFailuresResponse listImportFailuresResponse = (ListImportFailuresResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImportFailures").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportFailuresRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportFailuresRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportFailuresResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listImportFailures$63((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws EventDataStoreArnInvalidException, InvalidNextTokenException, InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListImportsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listImportsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listImportsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListImports");
            ListImportsResponse listImportsResponse = (ListImportsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListImports").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listImportsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListImportsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listImportsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listImports$65((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListInsightsMetricDataResponse listInsightsMetricData(ListInsightsMetricDataRequest listInsightsMetricDataRequest) throws InvalidParameterException, OperationNotPermittedException, UnsupportedOperationException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListInsightsMetricDataResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }
                case "InsufficientEncryptionPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientEncryptionPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientEncryptionPolicyException::builder).build());
                }
                case "ResourcePolicyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotFoundException::builder).build());
                }
                case "DelegatedAdminAccountLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("DelegatedAdminAccountLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(DelegatedAdminAccountLimitExceededException::builder).build());
                }
                case "EventDataStoreARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreArnInvalidException::builder).build());
                }
                case "InvalidS3PrefixException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3PrefixException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3PrefixException::builder).build());
                }
                case "InsufficientSnsTopicPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientSnsTopicPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientSnsTopicPolicyException::builder).build());
                }
                case "InvalidHomeRegionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidHomeRegionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidHomeRegionException::builder).build());
                }
                case "InsufficientDependencyServiceAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientDependencyServiceAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientDependencyServiceAccessPermissionException::builder).build());
                }
                case "ChannelAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelAlreadyExistsException::builder).build());
                }
                case "InvalidParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterException::builder).build());
                }
                case "ChannelARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelArnInvalidException::builder).build());
                }
                case "QueryIdNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("QueryIdNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(QueryIdNotFoundException::builder).build());
                }
                case "InactiveEventDataStoreException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveEventDataStoreException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveEventDataStoreException::builder).build());
                }
                case "TrailNotProvidedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotProvidedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotProvidedException::builder).build());
                }
                case "InvalidQueryStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatusException::builder).build());
                }
                case "InvalidEventCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventCategoryException::builder).build());
                }
                case "KmsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsException::builder).build());
                }
                case "OrganizationNotInAllFeaturesModeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationNotInAllFeaturesModeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationNotInAllFeaturesModeException::builder).build());
                }
                case "ThrottlingException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ThrottlingException::builder).build());
                }
                case "S3BucketDoesNotExistException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("S3BucketDoesNotExistException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(S3BucketDoesNotExistException::builder).build());
                }
                case "CannotDelegateManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CannotDelegateManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CannotDelegateManagementAccountException::builder).build());
                }
                case "TagsLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TagsLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TagsLimitExceededException::builder).build());
                }
                case "InvalidSnsTopicNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSnsTopicNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSnsTopicNameException::builder).build());
                }
                case "KmsKeyNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("KmsKeyNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(KmsKeyNotFoundException::builder).build());
                }
                case "AccountRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountRegisteredException::builder).build());
                }
                case "OperationNotPermittedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OperationNotPermittedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OperationNotPermittedException::builder).build());
                }
                case "AccountHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountHasOngoingImportException::builder).build());
                }
                case "ResourceTypeNotSupportedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceTypeNotSupportedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceTypeNotSupportedException::builder).build());
                }
                case "InvalidTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTokenException::builder).build());
                }
                case "AccessDeniedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccessDeniedException::builder).build());
                }
                case "ConflictException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConflictException::builder).build());
                }
                case "InvalidCloudWatchLogsRoleArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsRoleArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsRoleArnException::builder).build());
                }
                case "InvalidQueryStatementException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidQueryStatementException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidQueryStatementException::builder).build());
                }
                case "InvalidTimeRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTimeRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTimeRangeException::builder).build());
                }
                case "ImportNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ImportNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ImportNotFoundException::builder).build());
                }
                case "AccountNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotFoundException::builder).build());
                }
                case "InvalidParameterCombinationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidParameterCombinationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidParameterCombinationException::builder).build());
                }
                case "InvalidMaxResultsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidMaxResultsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidMaxResultsException::builder).build());
                }
                case "InvalidS3BucketNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidS3BucketNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidS3BucketNameException::builder).build());
                }
                case "CloudWatchLogsDeliveryUnavailableException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudWatchLogsDeliveryUnavailableException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudWatchLogsDeliveryUnavailableException::builder).build());
                }
                case "InactiveQueryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InactiveQueryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InactiveQueryException::builder).build());
                }
                case "ChannelMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreNotFoundException::builder).build());
                }
                case "InvalidTagParameterException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTagParameterException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTagParameterException::builder).build());
                }
                case "TrailNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailNotFoundException::builder).build());
                }
                case "MaximumNumberOfTrailsExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaximumNumberOfTrailsExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaximumNumberOfTrailsExceededException::builder).build());
                }
                case "EventDataStoreHasOngoingImportException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreHasOngoingImportException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreHasOngoingImportException::builder).build());
                }
                case "InvalidInsightSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidInsightSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidInsightSelectorsException::builder).build());
                }
                case "InvalidDateRangeException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidDateRangeException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidDateRangeException::builder).build());
                }
                case "NotOrganizationManagementAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationManagementAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationManagementAccountException::builder).build());
                }
                case "ChannelNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelNotFoundException::builder).build());
                }
                case "MaxConcurrentQueriesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("MaxConcurrentQueriesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(MaxConcurrentQueriesException::builder).build());
                }
                case "InsufficientS3BucketPolicyException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientS3BucketPolicyException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientS3BucketPolicyException::builder).build());
                }
                case "TrailAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("TrailAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(TrailAlreadyExistsException::builder).build());
                }
                case "InsightNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsightNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsightNotEnabledException::builder).build());
                }
            }
            return Optional.empty();
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = this.updateSdkClientConfiguration((SdkRequest)listInsightsMetricDataRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = DefaultCloudTrailClient.resolveMetricPublishers(clientConfiguration, listInsightsMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudTrail");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListInsightsMetricData");
            ListInsightsMetricDataResponse listInsightsMetricDataResponse = (ListInsightsMetricDataResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListInsightsMetricData").withProtocolMetadata((SdkProtocolMetadata)protocolMetadata).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration).withInput((SdkRequest)listInsightsMetricDataRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListInsightsMetricDataRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listInsightsMetricDataResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudTrailClient.lambda$listInsightsMetricData$67((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListPublicKeysResponse listPublicKeys(ListPublicKeysRequest listPublicKeysRequest) throws InvalidTimeRangeException, UnsupportedOperationException, OperationNotPermittedException, InvalidTokenException, AwsServiceException, SdkClientException, CloudTrailException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListPublicKeysResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
                case "ConcurrentModificationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ConcurrentModificationException::builder).build());
                }
                case "EventDataStoreMaxLimitExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreMaxLimitExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreMaxLimitExceededException::builder).build());
                }
                case "EventDataStoreTerminationProtectedException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreTerminationProtectedException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreTerminationProtectedException::builder).build());
                }
                case "ResourcePolicyNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourcePolicyNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourcePolicyNotValidException::builder).build());
                }
                case "InvalidKmsKeyIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidKmsKeyIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidKmsKeyIdException::builder).build());
                }
                case "InsufficientIAMAccessPermissionException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InsufficientIAMAccessPermissionException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InsufficientIamAccessPermissionException::builder).build());
                }
                case "ResourceARNNotValidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceARNNotValidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceArnNotValidException::builder).build());
                }
                case "InvalidCloudWatchLogsLogGroupArnException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidCloudWatchLogsLogGroupArnException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidCloudWatchLogsLogGroupArnException::builder).build());
                }
                case "InvalidEventDataStoreCategoryException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreCategoryException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreCategoryException::builder).build());
                }
                case "InvalidSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidSourceException::builder).build());
                }
                case "EventDataStoreAlreadyExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreAlreadyExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreAlreadyExistsException::builder).build());
                }
                case "CloudTrailARNInvalidException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailARNInvalidException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailArnInvalidException::builder).build());
                }
                case "NotOrganizationMasterAccountException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NotOrganizationMasterAccountException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NotOrganizationMasterAccountException::builder).build());
                }
                case "ServiceQuotaExceededException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
                }
                case "InvalidLookupAttributesException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidLookupAttributesException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidLookupAttributesException::builder).build());
                }
                case "CloudTrailInvalidClientTokenIdException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailInvalidClientTokenIdException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailInvalidClientTokenIdException::builder).build());
                }
                case "OrganizationsNotInUseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("OrganizationsNotInUseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(OrganizationsNotInUseException::builder).build());
                }
                case "InvalidNextTokenException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidNextTokenException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidNextTokenException::builder).build());
                }
                case "GenerateResponseException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("GenerateResponseException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(GenerateResponseException::builder).build());
                }
                case "ChannelExistsForEDSException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ChannelExistsForEDSException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ChannelExistsForEdsException::builder).build());
                }
                case "ResourceNotFoundException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
                }
                case "InvalidEventSelectorsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventSelectorsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventSelectorsException::builder).build());
                }
                case "UnsupportedOperationException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("UnsupportedOperationException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(UnsupportedOperationException::builder).build());
                }
                case "InvalidEventDataStoreStatusException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidEventDataStoreStatusException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidEventDataStoreStatusException::builder).build());
                }
                case "AccountNotRegisteredException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("AccountNotRegisteredException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(AccountNotRegisteredException::builder).build());
                }
                case "EventDataStoreFederationEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("EventDataStoreFederationEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(EventDataStoreFederationEnabledException::builder).build());
                }
                case "NoManagementAccountSLRExistsException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("NoManagementAccountSLRExistsException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(NoManagementAccountSlrExistsException::builder).build());
                }
                case "CloudTrailAccessNotEnabledException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("CloudTrailAccessNotEnabledException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(CloudTrailAccessNotEnabledException::builder).build());
                }
                case "InvalidTrailNameException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidTrailNameException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidTrailNameException::builder).build());
                }
                case "InvalidImportSourceException": {
                    return Optional.of(ExceptionMetadata.builder().errorCode("InvalidImportSourceException").httpStatusCode(Integer.valueOf(400)).exceptionBuilderSupplier(InvalidImportSourceException::builder).build());
                }