/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.InsightType;
import software.amazon.awssdk.services.cloudtrail.model.InsightsMetricDataType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInsightsMetricDataRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, ListInsightsMetricDataRequest> {
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::eventSource)).setter(ListInsightsMetricDataRequest.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventName").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::eventName)).setter(ListInsightsMetricDataRequest.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventName").build()}).build();
    private static final SdkField<String> INSIGHT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InsightType").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::insightTypeAsString)).setter(ListInsightsMetricDataRequest.setter(Builder::insightType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InsightType").build()}).build();
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ErrorCode").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::errorCode)).setter(ListInsightsMetricDataRequest.setter(Builder::errorCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorCode").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::startTime)).setter(ListInsightsMetricDataRequest.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::endTime)).setter(ListInsightsMetricDataRequest.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final SdkField<Integer> PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Period").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::period)).setter(ListInsightsMetricDataRequest.setter(Builder::period)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Period").build()}).build();
    private static final SdkField<String> DATA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataType").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::dataTypeAsString)).setter(ListInsightsMetricDataRequest.setter(Builder::dataType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataType").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::maxResults)).setter(ListInsightsMetricDataRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListInsightsMetricDataRequest.getter(ListInsightsMetricDataRequest::nextToken)).setter(ListInsightsMetricDataRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_SOURCE_FIELD, EVENT_NAME_FIELD, INSIGHT_TYPE_FIELD, ERROR_CODE_FIELD, START_TIME_FIELD, END_TIME_FIELD, PERIOD_FIELD, DATA_TYPE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventSource", EVENT_SOURCE_FIELD);
            this.put("EventName", EVENT_NAME_FIELD);
            this.put("InsightType", INSIGHT_TYPE_FIELD);
            this.put("ErrorCode", ERROR_CODE_FIELD);
            this.put("StartTime", START_TIME_FIELD);
            this.put("EndTime", END_TIME_FIELD);
            this.put("Period", PERIOD_FIELD);
            this.put("DataType", DATA_TYPE_FIELD);
            this.put("MaxResults", MAX_RESULTS_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final String eventSource;
    private final String eventName;
    private final String insightType;
    private final String errorCode;
    private final Instant startTime;
    private final Instant endTime;
    private final Integer period;
    private final String dataType;
    private final Integer maxResults;
    private final String nextToken;

    private ListInsightsMetricDataRequest(BuilderImpl builder) {
        super(builder);
        this.eventSource = builder.eventSource;
        this.eventName = builder.eventName;
        this.insightType = builder.insightType;
        this.errorCode = builder.errorCode;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.dataType = builder.dataType;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String eventSource() {
        return this.eventSource;
    }

    public final String eventName() {
        return this.eventName;
    }

    public final InsightType insightType() {
        return InsightType.fromValue(this.insightType);
    }

    public final String insightTypeAsString() {
        return this.insightType;
    }

    public final String errorCode() {
        return this.errorCode;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final Integer period() {
        return this.period;
    }

    public final InsightsMetricDataType dataType() {
        return InsightsMetricDataType.fromValue(this.dataType);
    }

    public final String dataTypeAsString() {
        return this.dataType;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.insightTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.period());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInsightsMetricDataRequest)) {
            return false;
        }
        ListInsightsMetricDataRequest other = (ListInsightsMetricDataRequest)((Object)obj);
        return Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.eventName(), other.eventName()) && Objects.equals(this.insightTypeAsString(), other.insightTypeAsString()) && Objects.equals(this.errorCode(), other.errorCode()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.period(), other.period()) && Objects.equals(this.dataTypeAsString(), other.dataTypeAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInsightsMetricDataRequest").add("EventSource", (Object)this.eventSource()).add("EventName", (Object)this.eventName()).add("InsightType", (Object)this.insightTypeAsString()).add("ErrorCode", (Object)this.errorCode()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("Period", (Object)this.period()).add("DataType", (Object)this.dataTypeAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "EventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
            case "InsightType": {
                return Optional.ofNullable(clazz.cast(this.insightTypeAsString()));
            }
            case "ErrorCode": {
                return Optional.ofNullable(clazz.cast(this.errorCode()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "Period": {
                return Optional.ofNullable(clazz.cast(this.period()));
            }
            case "DataType": {
                return Optional.ofNullable(clazz.cast(this.dataTypeAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListInsightsMetricDataRequest, T> g) {
        return obj -> g.apply((ListInsightsMetricDataRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String eventSource;
        private String eventName;
        private String insightType;
        private String errorCode;
        private Instant startTime;
        private Instant endTime;
        private Integer period;
        private String dataType;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInsightsMetricDataRequest model) {
            super(model);
            this.eventSource(model.eventSource);
            this.eventName(model.eventName);
            this.insightType(model.insightType);
            this.errorCode(model.errorCode);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.period(model.period);
            this.dataType(model.dataType);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final String getInsightType() {
            return this.insightType;
        }

        public final void setInsightType(String insightType) {
            this.insightType = insightType;
        }

        @Override
        public final Builder insightType(String insightType) {
            this.insightType = insightType;
            return this;
        }

        @Override
        public final Builder insightType(InsightType insightType) {
            this.insightType(insightType == null ? null : insightType.toString());
            return this;
        }

        public final String getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final Integer getPeriod() {
            return this.period;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final String getDataType() {
            return this.dataType;
        }

        public final void setDataType(String dataType) {
            this.dataType = dataType;
        }

        @Override
        public final Builder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        @Override
        public final Builder dataType(InsightsMetricDataType dataType) {
            this.dataType(dataType == null ? null : dataType.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListInsightsMetricDataRequest build() {
            return new ListInsightsMetricDataRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInsightsMetricDataRequest> {
        public Builder eventSource(String var1);

        public Builder eventName(String var1);

        public Builder insightType(String var1);

        public Builder insightType(InsightType var1);

        public Builder errorCode(String var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder period(Integer var1);

        public Builder dataType(String var1);

        public Builder dataType(InsightsMetricDataType var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

