/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns the objects or data listed below if successful. Otherwise, returns an error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPublicKeysResponse extends CloudTrailResponse implements
        ToCopyableBuilder<ListPublicKeysResponse.Builder, ListPublicKeysResponse> {
    private static final SdkField<List<PublicKey>> PUBLIC_KEY_LIST_FIELD = SdkField
            .<List<PublicKey>> builder(MarshallingType.LIST)
            .memberName("PublicKeyList")
            .getter(getter(ListPublicKeysResponse::publicKeyList))
            .setter(setter(Builder::publicKeyList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKeyList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PublicKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(PublicKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListPublicKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PUBLIC_KEY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<PublicKey> publicKeyList;

    private final String nextToken;

    private ListPublicKeysResponse(BuilderImpl builder) {
        super(builder);
        this.publicKeyList = builder.publicKeyList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PublicKeyList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPublicKeyList() {
        return publicKeyList != null && !(publicKeyList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains an array of PublicKey objects.
     * </p>
     * <note>
     * <p>
     * The returned public keys may have validity time ranges that overlap.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPublicKeyList} method.
     * </p>
     * 
     * @return Contains an array of PublicKey objects.</p> <note>
     *         <p>
     *         The returned public keys may have validity time ranges that overlap.
     *         </p>
     */
    public final List<PublicKey> publicKeyList() {
        return publicKeyList;
    }

    /**
     * <p>
     * Reserved for future use.
     * </p>
     * 
     * @return Reserved for future use.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPublicKeyList() ? publicKeyList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPublicKeysResponse)) {
            return false;
        }
        ListPublicKeysResponse other = (ListPublicKeysResponse) obj;
        return hasPublicKeyList() == other.hasPublicKeyList() && Objects.equals(publicKeyList(), other.publicKeyList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPublicKeysResponse").add("PublicKeyList", hasPublicKeyList() ? publicKeyList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PublicKeyList":
            return Optional.ofNullable(clazz.cast(publicKeyList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListPublicKeysResponse, T> g) {
        return obj -> g.apply((ListPublicKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPublicKeysResponse> {
        /**
         * <p>
         * Contains an array of PublicKey objects.
         * </p>
         * <note>
         * <p>
         * The returned public keys may have validity time ranges that overlap.
         * </p>
         * </note>
         * 
         * @param publicKeyList
         *        Contains an array of PublicKey objects.</p> <note>
         *        <p>
         *        The returned public keys may have validity time ranges that overlap.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyList(Collection<PublicKey> publicKeyList);

        /**
         * <p>
         * Contains an array of PublicKey objects.
         * </p>
         * <note>
         * <p>
         * The returned public keys may have validity time ranges that overlap.
         * </p>
         * </note>
         * 
         * @param publicKeyList
         *        Contains an array of PublicKey objects.</p> <note>
         *        <p>
         *        The returned public keys may have validity time ranges that overlap.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKeyList(PublicKey... publicKeyList);

        /**
         * <p>
         * Contains an array of PublicKey objects.
         * </p>
         * <note>
         * <p>
         * The returned public keys may have validity time ranges that overlap.
         * </p>
         * </note> This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.cloudtrail.model.PublicKey.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.cloudtrail.model.PublicKey#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.cloudtrail.model.PublicKey.Builder#build()} is called immediately and
         * its result is passed to {@link #publicKeyList(List<PublicKey>)}.
         * 
         * @param publicKeyList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.cloudtrail.model.PublicKey.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #publicKeyList(java.util.Collection<PublicKey>)
         */
        Builder publicKeyList(Consumer<PublicKey.Builder>... publicKeyList);

        /**
         * <p>
         * Reserved for future use.
         * </p>
         * 
         * @param nextToken
         *        Reserved for future use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends CloudTrailResponse.BuilderImpl implements Builder {
        private List<PublicKey> publicKeyList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPublicKeysResponse model) {
            super(model);
            publicKeyList(model.publicKeyList);
            nextToken(model.nextToken);
        }

        public final List<PublicKey.Builder> getPublicKeyList() {
            List<PublicKey.Builder> result = PublicKeyListCopier.copyToBuilder(this.publicKeyList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPublicKeyList(Collection<PublicKey.BuilderImpl> publicKeyList) {
            this.publicKeyList = PublicKeyListCopier.copyFromBuilder(publicKeyList);
        }

        @Override
        public final Builder publicKeyList(Collection<PublicKey> publicKeyList) {
            this.publicKeyList = PublicKeyListCopier.copy(publicKeyList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeyList(PublicKey... publicKeyList) {
            publicKeyList(Arrays.asList(publicKeyList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder publicKeyList(Consumer<PublicKey.Builder>... publicKeyList) {
            publicKeyList(Stream.of(publicKeyList).map(c -> PublicKey.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPublicKeysResponse build() {
            return new ListPublicKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
