/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum ReadWriteType {
    READ_ONLY("ReadOnly"),
    WRITE_ONLY("WriteOnly"),
    ALL("All"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private ReadWriteType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ReadWriteType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(ReadWriteType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ReadWriteType> knownValues() {
        return Stream.of(ReadWriteType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

