/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.Resource;
import software.amazon.awssdk.services.cloudtrail.model.ResourceListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventId").getter(Event.getter(Event::eventId)).setter(Event.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventId").build()}).build();
    private static final SdkField<String> EVENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventName").getter(Event.getter(Event::eventName)).setter(Event.setter(Builder::eventName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventName").build()}).build();
    private static final SdkField<String> READ_ONLY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReadOnly").getter(Event.getter(Event::readOnly)).setter(Event.setter(Builder::readOnly)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReadOnly").build()}).build();
    private static final SdkField<String> ACCESS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessKeyId").getter(Event.getter(Event::accessKeyId)).setter(Event.setter(Builder::accessKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessKeyId").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EventTime").getter(Event.getter(Event::eventTime)).setter(Event.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventTime").build()}).build();
    private static final SdkField<String> EVENT_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventSource").getter(Event.getter(Event::eventSource)).setter(Event.setter(Builder::eventSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventSource").build()}).build();
    private static final SdkField<String> USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Username").getter(Event.getter(Event::username)).setter(Event.setter(Builder::username)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Username").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Resources").getter(Event.getter(Event::resources)).setter(Event.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLOUD_TRAIL_EVENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CloudTrailEvent").getter(Event.getter(Event::cloudTrailEvent)).setter(Event.setter(Builder::cloudTrailEvent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudTrailEvent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_NAME_FIELD, READ_ONLY_FIELD, ACCESS_KEY_ID_FIELD, EVENT_TIME_FIELD, EVENT_SOURCE_FIELD, USERNAME_FIELD, RESOURCES_FIELD, CLOUD_TRAIL_EVENT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String eventName;
    private final String readOnly;
    private final String accessKeyId;
    private final Instant eventTime;
    private final String eventSource;
    private final String username;
    private final List<Resource> resources;
    private final String cloudTrailEvent;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventName = builder.eventName;
        this.readOnly = builder.readOnly;
        this.accessKeyId = builder.accessKeyId;
        this.eventTime = builder.eventTime;
        this.eventSource = builder.eventSource;
        this.username = builder.username;
        this.resources = builder.resources;
        this.cloudTrailEvent = builder.cloudTrailEvent;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventName() {
        return this.eventName;
    }

    public final String readOnly() {
        return this.readOnly;
    }

    public final String accessKeyId() {
        return this.accessKeyId;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String eventSource() {
        return this.eventSource;
    }

    public final String username() {
        return this.username;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final String cloudTrailEvent() {
        return this.cloudTrailEvent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventName());
        hashCode = 31 * hashCode + Objects.hashCode(this.readOnly());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.username());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudTrailEvent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventName(), other.eventName()) && Objects.equals(this.readOnly(), other.readOnly()) && Objects.equals(this.accessKeyId(), other.accessKeyId()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.eventSource(), other.eventSource()) && Objects.equals(this.username(), other.username()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && Objects.equals(this.cloudTrailEvent(), other.cloudTrailEvent());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("EventId", (Object)this.eventId()).add("EventName", (Object)this.eventName()).add("ReadOnly", (Object)this.readOnly()).add("AccessKeyId", (Object)this.accessKeyId()).add("EventTime", (Object)this.eventTime()).add("EventSource", (Object)this.eventSource()).add("Username", (Object)this.username()).add("Resources", this.hasResources() ? this.resources() : null).add("CloudTrailEvent", (Object)this.cloudTrailEvent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "EventName": {
                return Optional.ofNullable(clazz.cast(this.eventName()));
            }
            case "ReadOnly": {
                return Optional.ofNullable(clazz.cast(this.readOnly()));
            }
            case "AccessKeyId": {
                return Optional.ofNullable(clazz.cast(this.accessKeyId()));
            }
            case "EventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "EventSource": {
                return Optional.ofNullable(clazz.cast(this.eventSource()));
            }
            case "Username": {
                return Optional.ofNullable(clazz.cast(this.username()));
            }
            case "Resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "CloudTrailEvent": {
                return Optional.ofNullable(clazz.cast(this.cloudTrailEvent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String eventName;
        private String readOnly;
        private String accessKeyId;
        private Instant eventTime;
        private String eventSource;
        private String username;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private String cloudTrailEvent;

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.eventId(model.eventId);
            this.eventName(model.eventName);
            this.readOnly(model.readOnly);
            this.accessKeyId(model.accessKeyId);
            this.eventTime(model.eventTime);
            this.eventSource(model.eventSource);
            this.username(model.username);
            this.resources(model.resources);
            this.cloudTrailEvent(model.cloudTrailEvent);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        @Transient
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventName() {
            return this.eventName;
        }

        public final void setEventName(String eventName) {
            this.eventName = eventName;
        }

        @Override
        @Transient
        public final Builder eventName(String eventName) {
            this.eventName = eventName;
            return this;
        }

        public final String getReadOnly() {
            return this.readOnly;
        }

        public final void setReadOnly(String readOnly) {
            this.readOnly = readOnly;
        }

        @Override
        @Transient
        public final Builder readOnly(String readOnly) {
            this.readOnly = readOnly;
            return this;
        }

        public final String getAccessKeyId() {
            return this.accessKeyId;
        }

        public final void setAccessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
        }

        @Override
        @Transient
        public final Builder accessKeyId(String accessKeyId) {
            this.accessKeyId = accessKeyId;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        @Transient
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getEventSource() {
            return this.eventSource;
        }

        public final void setEventSource(String eventSource) {
            this.eventSource = eventSource;
        }

        @Override
        @Transient
        public final Builder eventSource(String eventSource) {
            this.eventSource = eventSource;
            return this;
        }

        public final String getUsername() {
            return this.username;
        }

        public final void setUsername(String username) {
            this.username = username;
        }

        @Override
        @Transient
        public final Builder username(String username) {
            this.username = username;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        @Transient
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getCloudTrailEvent() {
            return this.cloudTrailEvent;
        }

        public final void setCloudTrailEvent(String cloudTrailEvent) {
            this.cloudTrailEvent = cloudTrailEvent;
        }

        @Override
        @Transient
        public final Builder cloudTrailEvent(String cloudTrailEvent) {
            this.cloudTrailEvent = cloudTrailEvent;
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder eventId(String var1);

        public Builder eventName(String var1);

        public Builder readOnly(String var1);

        public Builder accessKeyId(String var1);

        public Builder eventTime(Instant var1);

        public Builder eventSource(String var1);

        public Builder username(String var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder cloudTrailEvent(String var1);
    }
}

