/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTag;
import software.amazon.awssdk.services.cloudtrail.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, ListTagsResponse> {
    private static final SdkField<List<ResourceTag>> RESOURCE_TAG_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResourceTagList").getter(ListTagsResponse.getter(ListTagsResponse::resourceTagList)).setter(ListTagsResponse.setter(Builder::resourceTagList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceTagList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTagsResponse.getter(ListTagsResponse::nextToken)).setter(ListTagsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAG_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<ResourceTag> resourceTagList;
    private final String nextToken;

    private ListTagsResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTagList = builder.resourceTagList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasResourceTagList() {
        return this.resourceTagList != null && !(this.resourceTagList instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTagList() {
        return this.resourceTagList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTagList() ? this.resourceTagList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsResponse)) {
            return false;
        }
        ListTagsResponse other = (ListTagsResponse)((Object)obj);
        return this.hasResourceTagList() == other.hasResourceTagList() && Objects.equals(this.resourceTagList(), other.resourceTagList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagsResponse").add("ResourceTagList", this.hasResourceTagList() ? this.resourceTagList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResourceTagList": {
                return Optional.ofNullable(clazz.cast(this.resourceTagList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTagsResponse, T> g) {
        return obj -> g.apply((ListTagsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private List<ResourceTag> resourceTagList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsResponse model) {
            super(model);
            this.resourceTagList(model.resourceTagList);
            this.nextToken(model.nextToken);
        }

        public final Collection<ResourceTag.Builder> getResourceTagList() {
            if (this.resourceTagList instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resourceTagList != null ? (Collection)this.resourceTagList.stream().map(ResourceTag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceTagList(Collection<ResourceTag> resourceTagList) {
            this.resourceTagList = ResourceTagListCopier.copy(resourceTagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagList(ResourceTag ... resourceTagList) {
            this.resourceTagList(Arrays.asList(resourceTagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTagList(Consumer<ResourceTag.Builder> ... resourceTagList) {
            this.resourceTagList(Stream.of(resourceTagList).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceTagList(Collection<ResourceTag.BuilderImpl> resourceTagList) {
            this.resourceTagList = ResourceTagListCopier.copyFromBuilder(resourceTagList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListTagsResponse build() {
            return new ListTagsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsResponse> {
        public Builder resourceTagList(Collection<ResourceTag> var1);

        public Builder resourceTagList(ResourceTag ... var1);

        public Builder resourceTagList(Consumer<ResourceTag.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

