/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum EventCategory {
    INSIGHT("insight"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private EventCategory(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EventCategory fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(EventCategory.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EventCategory> knownValues() {
        return Stream.of(EventCategory.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

