/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Returns information about the trail.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTrailsRequest extends CloudTrailRequest implements
        ToCopyableBuilder<DescribeTrailsRequest.Builder, DescribeTrailsRequest> {
    private static final SdkField<List<String>> TRAIL_NAME_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeTrailsRequest::trailNameList))
            .setter(setter(Builder::trailNameList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trailNameList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> INCLUDE_SHADOW_TRAILS_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeTrailsRequest::includeShadowTrails)).setter(setter(Builder::includeShadowTrails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("includeShadowTrails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_LIST_FIELD,
            INCLUDE_SHADOW_TRAILS_FIELD));

    private final List<String> trailNameList;

    private final Boolean includeShadowTrails;

    private DescribeTrailsRequest(BuilderImpl builder) {
        super(builder);
        this.trailNameList = builder.trailNameList;
        this.includeShadowTrails = builder.includeShadowTrails;
    }

    /**
     * Returns true if the TrailNameList property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTrailNameList() {
        return trailNameList != null && !(trailNameList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN is:
     * </p>
     * <p>
     * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     * </p>
     * <p>
     * If an empty list is specified, information for the trail in the current region is returned.
     * </p>
     * <ul>
     * <li>
     * <p>
     * If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails in
     * the current region is returned.
     * </p>
     * </li>
     * <li>
     * <p>
     * If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the
     * current region and any associated shadow trails in other regions is returned.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * If one or more trail names are specified, information is returned only if the names match the names of trails
     * belonging only to the current region. To return information about a trail in another region, you must specify its
     * trail ARN.
     * </p>
     * </note>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTrailNameList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail
     *         ARN is:</p>
     *         <p>
     *         <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
     *         </p>
     *         <p>
     *         If an empty list is specified, information for the trail in the current region is returned.
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all
     *         trails in the current region is returned.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in
     *         the current region and any associated shadow trails in other regions is returned.
     *         </p>
     *         </li>
     *         </ul>
     *         <note>
     *         <p>
     *         If one or more trail names are specified, information is returned only if the names match the names of
     *         trails belonging only to the current region. To return information about a trail in another region, you
     *         must specify its trail ARN.
     *         </p>
     */
    public List<String> trailNameList() {
        return trailNameList;
    }

    /**
     * <p>
     * Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of a
     * trail that was created in a different region, or in the case of an organization trail, the replication of an
     * organization trail in member accounts. If you do not include shadow trails, organization trails in a member
     * account and region replication trails will not be returned. The default is true.
     * </p>
     * 
     * @return Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region
     *         of a trail that was created in a different region, or in the case of an organization trail, the
     *         replication of an organization trail in member accounts. If you do not include shadow trails,
     *         organization trails in a member account and region replication trails will not be returned. The default
     *         is true.
     */
    public Boolean includeShadowTrails() {
        return includeShadowTrails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(trailNameList());
        hashCode = 31 * hashCode + Objects.hashCode(includeShadowTrails());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTrailsRequest)) {
            return false;
        }
        DescribeTrailsRequest other = (DescribeTrailsRequest) obj;
        return Objects.equals(trailNameList(), other.trailNameList())
                && Objects.equals(includeShadowTrails(), other.includeShadowTrails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeTrailsRequest").add("TrailNameList", trailNameList())
                .add("IncludeShadowTrails", includeShadowTrails()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "trailNameList":
            return Optional.ofNullable(clazz.cast(trailNameList()));
        case "includeShadowTrails":
            return Optional.ofNullable(clazz.cast(includeShadowTrails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTrailsRequest, T> g) {
        return obj -> g.apply((DescribeTrailsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudTrailRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeTrailsRequest> {
        /**
         * <p>
         * Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN
         * is:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * <p>
         * If an empty list is specified, information for the trail in the current region is returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails
         * in the current region is returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the
         * current region and any associated shadow trails in other regions is returned.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If one or more trail names are specified, information is returned only if the names match the names of trails
         * belonging only to the current region. To return information about a trail in another region, you must specify
         * its trail ARN.
         * </p>
         * </note>
         * 
         * @param trailNameList
         *        Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail
         *        ARN is:</p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         *        </p>
         *        <p>
         *        If an empty list is specified, information for the trail in the current region is returned.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all
         *        trails in the current region is returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails
         *        in the current region and any associated shadow trails in other regions is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If one or more trail names are specified, information is returned only if the names match the names of
         *        trails belonging only to the current region. To return information about a trail in another region,
         *        you must specify its trail ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailNameList(Collection<String> trailNameList);

        /**
         * <p>
         * Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail ARN
         * is:
         * </p>
         * <p>
         * <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         * </p>
         * <p>
         * If an empty list is specified, information for the trail in the current region is returned.
         * </p>
         * <ul>
         * <li>
         * <p>
         * If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all trails
         * in the current region is returned.
         * </p>
         * </li>
         * <li>
         * <p>
         * If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails in the
         * current region and any associated shadow trails in other regions is returned.
         * </p>
         * </li>
         * </ul>
         * <note>
         * <p>
         * If one or more trail names are specified, information is returned only if the names match the names of trails
         * belonging only to the current region. To return information about a trail in another region, you must specify
         * its trail ARN.
         * </p>
         * </note>
         * 
         * @param trailNameList
         *        Specifies a list of trail names, trail ARNs, or both, of the trails to describe. The format of a trail
         *        ARN is:</p>
         *        <p>
         *        <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/MyTrail</code>
         *        </p>
         *        <p>
         *        If an empty list is specified, information for the trail in the current region is returned.
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        If an empty list is specified and <code>IncludeShadowTrails</code> is false, then information for all
         *        trails in the current region is returned.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        If an empty list is specified and IncludeShadowTrails is null or true, then information for all trails
         *        in the current region and any associated shadow trails in other regions is returned.
         *        </p>
         *        </li>
         *        </ul>
         *        <note>
         *        <p>
         *        If one or more trail names are specified, information is returned only if the names match the names of
         *        trails belonging only to the current region. To return information about a trail in another region,
         *        you must specify its trail ARN.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder trailNameList(String... trailNameList);

        /**
         * <p>
         * Specifies whether to include shadow trails in the response. A shadow trail is the replication in a region of
         * a trail that was created in a different region, or in the case of an organization trail, the replication of
         * an organization trail in member accounts. If you do not include shadow trails, organization trails in a
         * member account and region replication trails will not be returned. The default is true.
         * </p>
         * 
         * @param includeShadowTrails
         *        Specifies whether to include shadow trails in the response. A shadow trail is the replication in a
         *        region of a trail that was created in a different region, or in the case of an organization trail, the
         *        replication of an organization trail in member accounts. If you do not include shadow trails,
         *        organization trails in a member account and region replication trails will not be returned. The
         *        default is true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeShadowTrails(Boolean includeShadowTrails);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudTrailRequest.BuilderImpl implements Builder {
        private List<String> trailNameList = DefaultSdkAutoConstructList.getInstance();

        private Boolean includeShadowTrails;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTrailsRequest model) {
            super(model);
            trailNameList(model.trailNameList);
            includeShadowTrails(model.includeShadowTrails);
        }

        public final Collection<String> getTrailNameList() {
            return trailNameList;
        }

        @Override
        public final Builder trailNameList(Collection<String> trailNameList) {
            this.trailNameList = TrailNameListCopier.copy(trailNameList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder trailNameList(String... trailNameList) {
            trailNameList(Arrays.asList(trailNameList));
            return this;
        }

        public final void setTrailNameList(Collection<String> trailNameList) {
            this.trailNameList = TrailNameListCopier.copy(trailNameList);
        }

        public final Boolean getIncludeShadowTrails() {
            return includeShadowTrails;
        }

        @Override
        public final Builder includeShadowTrails(Boolean includeShadowTrails) {
            this.includeShadowTrails = includeShadowTrails;
            return this;
        }

        public final void setIncludeShadowTrails(Boolean includeShadowTrails) {
            this.includeShadowTrails = includeShadowTrails;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeTrailsRequest build() {
            return new DescribeTrailsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
