/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionMatch;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestionsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SuggestModel
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SuggestModel> {
    private static final SdkField<String> QUERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("query").getter(SuggestModel.getter(SuggestModel::query)).setter(SuggestModel.setter(Builder::query)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("query").build()}).build();
    private static final SdkField<Long> FOUND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("found").getter(SuggestModel.getter(SuggestModel::found)).setter(SuggestModel.setter(Builder::found)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("found").build()}).build();
    private static final SdkField<List<SuggestionMatch>> SUGGESTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("suggestions").getter(SuggestModel.getter(SuggestModel::suggestions)).setter(SuggestModel.setter(Builder::suggestions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("suggestions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuggestionMatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUERY_FIELD, FOUND_FIELD, SUGGESTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String query;
    private final Long found;
    private final List<SuggestionMatch> suggestions;

    private SuggestModel(BuilderImpl builder) {
        this.query = builder.query;
        this.found = builder.found;
        this.suggestions = builder.suggestions;
    }

    public final String query() {
        return this.query;
    }

    public final Long found() {
        return this.found;
    }

    public final boolean hasSuggestions() {
        return this.suggestions != null && !(this.suggestions instanceof SdkAutoConstructList);
    }

    public final List<SuggestionMatch> suggestions() {
        return this.suggestions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.found());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuggestions() ? this.suggestions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SuggestModel)) {
            return false;
        }
        SuggestModel other = (SuggestModel)obj;
        return Objects.equals(this.query(), other.query()) && Objects.equals(this.found(), other.found()) && this.hasSuggestions() == other.hasSuggestions() && Objects.equals(this.suggestions(), other.suggestions());
    }

    public final String toString() {
        return ToString.builder((String)"SuggestModel").add("Query", (Object)this.query()).add("Found", (Object)this.found()).add("Suggestions", this.hasSuggestions() ? this.suggestions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "query": {
                return Optional.ofNullable(clazz.cast(this.query()));
            }
            case "found": {
                return Optional.ofNullable(clazz.cast(this.found()));
            }
            case "suggestions": {
                return Optional.ofNullable(clazz.cast(this.suggestions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SuggestModel, T> g) {
        return obj -> g.apply((SuggestModel)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String query;
        private Long found;
        private List<SuggestionMatch> suggestions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SuggestModel model) {
            this.query(model.query);
            this.found(model.found);
            this.suggestions(model.suggestions);
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final Long getFound() {
            return this.found;
        }

        @Override
        public final Builder found(Long found) {
            this.found = found;
            return this;
        }

        public final void setFound(Long found) {
            this.found = found;
        }

        public final List<SuggestionMatch.Builder> getSuggestions() {
            List<SuggestionMatch.Builder> result = SuggestionsCopier.copyToBuilder(this.suggestions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder suggestions(Collection<SuggestionMatch> suggestions) {
            this.suggestions = SuggestionsCopier.copy(suggestions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(SuggestionMatch ... suggestions) {
            this.suggestions(Arrays.asList(suggestions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggestions(Consumer<SuggestionMatch.Builder> ... suggestions) {
            this.suggestions(Stream.of(suggestions).map(c -> (SuggestionMatch)((SuggestionMatch.Builder)SuggestionMatch.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuggestions(Collection<SuggestionMatch.BuilderImpl> suggestions) {
            this.suggestions = SuggestionsCopier.copyFromBuilder(suggestions);
        }

        public SuggestModel build() {
            return new SuggestModel(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SuggestModel> {
        public Builder query(String var1);

        public Builder found(Long var1);

        public Builder suggestions(Collection<SuggestionMatch> var1);

        public Builder suggestions(SuggestionMatch ... var1);

        public Builder suggestions(Consumer<SuggestionMatch.Builder> ... var1);
    }
}

