/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.cloudsearchdomain.model.ExprsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.model.FieldsCopier;
import software.amazon.awssdk.services.cloudsearchdomain.model.HighlightsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Hit
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Hit> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(Hit.getter(Hit::id)).setter(Hit.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Map<String, List<String>>> FIELDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("fields").getter(Hit.getter(Hit::fields)).setter(Hit.setter(Builder::fields)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> EXPRS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("exprs").getter(Hit.getter(Hit::exprs)).setter(Hit.setter(Builder::exprs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exprs").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> HIGHLIGHTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("highlights").getter(Hit.getter(Hit::highlights)).setter(Hit.setter(Builder::highlights)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highlights").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FIELDS_FIELD, EXPRS_FIELD, HIGHLIGHTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String id;
    private final Map<String, List<String>> fields;
    private final Map<String, String> exprs;
    private final Map<String, String> highlights;

    private Hit(BuilderImpl builder) {
        this.id = builder.id;
        this.fields = builder.fields;
        this.exprs = builder.exprs;
        this.highlights = builder.highlights;
    }

    public final String id() {
        return this.id;
    }

    public final boolean hasFields() {
        return this.fields != null && !(this.fields instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<String>> fields() {
        return this.fields;
    }

    public final boolean hasExprs() {
        return this.exprs != null && !(this.exprs instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> exprs() {
        return this.exprs;
    }

    public final boolean hasHighlights() {
        return this.highlights != null && !(this.highlights instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> highlights() {
        return this.highlights;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFields() ? this.fields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExprs() ? this.exprs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHighlights() ? this.highlights() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hit)) {
            return false;
        }
        Hit other = (Hit)obj;
        return Objects.equals(this.id(), other.id()) && this.hasFields() == other.hasFields() && Objects.equals(this.fields(), other.fields()) && this.hasExprs() == other.hasExprs() && Objects.equals(this.exprs(), other.exprs()) && this.hasHighlights() == other.hasHighlights() && Objects.equals(this.highlights(), other.highlights());
    }

    public final String toString() {
        return ToString.builder((String)"Hit").add("Id", (Object)this.id()).add("Fields", this.hasFields() ? this.fields() : null).add("Exprs", this.hasExprs() ? this.exprs() : null).add("Highlights", this.hasHighlights() ? this.highlights() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "fields": {
                return Optional.ofNullable(clazz.cast(this.fields()));
            }
            case "exprs": {
                return Optional.ofNullable(clazz.cast(this.exprs()));
            }
            case "highlights": {
                return Optional.ofNullable(clazz.cast(this.highlights()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hit, T> g) {
        return obj -> g.apply((Hit)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private Map<String, List<String>> fields = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> exprs = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> highlights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Hit model) {
            this.id(model.id);
            this.fields(model.fields);
            this.exprs(model.exprs);
            this.highlights(model.highlights);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, ? extends Collection<String>> getFields() {
            if (this.fields instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.fields;
        }

        @Override
        public final Builder fields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
            return this;
        }

        public final void setFields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
        }

        public final Map<String, String> getExprs() {
            if (this.exprs instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.exprs;
        }

        @Override
        public final Builder exprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
            return this;
        }

        public final void setExprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
        }

        public final Map<String, String> getHighlights() {
            if (this.highlights instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.highlights;
        }

        @Override
        public final Builder highlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
            return this;
        }

        public final void setHighlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
        }

        public Hit build() {
            return new Hit(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Hit> {
        public Builder id(String var1);

        public Builder fields(Map<String, ? extends Collection<String>> var1);

        public Builder exprs(Map<String, String> var1);

        public Builder highlights(Map<String, String> var1);
    }
}

