/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain;

import java.nio.file.Path;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkClient;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.cloudsearchdomain.CloudSearchDomainClientBuilder;
import software.amazon.awssdk.services.cloudsearchdomain.DefaultCloudSearchDomainClientBuilder;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainException;
import software.amazon.awssdk.services.cloudsearchdomain.model.DocumentServiceException;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchException;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SuggestResponse;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.UploadDocumentsResponse;

public interface CloudSearchDomainClient
extends SdkClient {
    public static final String SERVICE_NAME = "cloudsearch";

    public static CloudSearchDomainClient create() {
        return (CloudSearchDomainClient)CloudSearchDomainClient.builder().build();
    }

    public static CloudSearchDomainClientBuilder builder() {
        return new DefaultCloudSearchDomainClientBuilder();
    }

    default public SearchResponse search(SearchRequest searchRequest) throws SearchException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        throw new UnsupportedOperationException();
    }

    default public SearchResponse search(Consumer<SearchRequest.Builder> searchRequest) throws SearchException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        return this.search((SearchRequest)((Object)((SearchRequest.Builder)SearchRequest.builder().applyMutation(searchRequest)).build()));
    }

    default public SuggestResponse suggest(SuggestRequest suggestRequest) throws SearchException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        throw new UnsupportedOperationException();
    }

    default public SuggestResponse suggest(Consumer<SuggestRequest.Builder> suggestRequest) throws SearchException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        return this.suggest((SuggestRequest)((Object)((SuggestRequest.Builder)SuggestRequest.builder().applyMutation(suggestRequest)).build()));
    }

    default public UploadDocumentsResponse uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, RequestBody requestBody) throws DocumentServiceException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        throw new UnsupportedOperationException();
    }

    default public UploadDocumentsResponse uploadDocuments(Consumer<UploadDocumentsRequest.Builder> uploadDocumentsRequest, RequestBody requestBody) throws DocumentServiceException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        return this.uploadDocuments((UploadDocumentsRequest)((Object)((UploadDocumentsRequest.Builder)UploadDocumentsRequest.builder().applyMutation(uploadDocumentsRequest)).build()), requestBody);
    }

    default public UploadDocumentsResponse uploadDocuments(UploadDocumentsRequest uploadDocumentsRequest, Path sourcePath) throws DocumentServiceException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        return this.uploadDocuments(uploadDocumentsRequest, RequestBody.fromFile((Path)sourcePath));
    }

    default public UploadDocumentsResponse uploadDocuments(Consumer<UploadDocumentsRequest.Builder> uploadDocumentsRequest, Path sourcePath) throws DocumentServiceException, AwsServiceException, SdkClientException, CloudSearchDomainException {
        return this.uploadDocuments((UploadDocumentsRequest)((Object)((UploadDocumentsRequest.Builder)UploadDocumentsRequest.builder().applyMutation(uploadDocumentsRequest)).build()), sourcePath);
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"cloudsearchdomain");
    }
}

