/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the response to an <code>UploadDocuments</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadDocumentsResponse extends CloudSearchDomainResponse implements
        ToCopyableBuilder<UploadDocumentsResponse.Builder, UploadDocumentsResponse> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(UploadDocumentsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Long> ADDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UploadDocumentsResponse::adds)).setter(setter(Builder::adds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adds").build()).build();

    private static final SdkField<Long> DELETES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(UploadDocumentsResponse::deletes)).setter(setter(Builder::deletes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deletes").build()).build();

    private static final SdkField<List<DocumentServiceWarning>> WARNINGS_FIELD = SdkField
            .<List<DocumentServiceWarning>> builder(MarshallingType.LIST)
            .getter(getter(UploadDocumentsResponse::warnings))
            .setter(setter(Builder::warnings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warnings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DocumentServiceWarning> builder(MarshallingType.SDK_POJO)
                                            .constructor(DocumentServiceWarning::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ADDS_FIELD,
            DELETES_FIELD, WARNINGS_FIELD));

    private final String status;

    private final Long adds;

    private final Long deletes;

    private final List<DocumentServiceWarning> warnings;

    private UploadDocumentsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.adds = builder.adds;
        this.deletes = builder.deletes;
        this.warnings = builder.warnings;
    }

    /**
     * <p>
     * The status of an <code>UploadDocumentsRequest</code>.
     * </p>
     * 
     * @return The status of an <code>UploadDocumentsRequest</code>.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The number of documents that were added to the search domain.
     * </p>
     * 
     * @return The number of documents that were added to the search domain.
     */
    public Long adds() {
        return adds;
    }

    /**
     * <p>
     * The number of documents that were deleted from the search domain.
     * </p>
     * 
     * @return The number of documents that were deleted from the search domain.
     */
    public Long deletes() {
        return deletes;
    }

    /**
     * Returns true if the Warnings property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasWarnings() {
        return warnings != null && !(warnings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any warnings returned by the document service about the documents being uploaded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasWarnings()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Any warnings returned by the document service about the documents being uploaded.
     */
    public List<DocumentServiceWarning> warnings() {
        return warnings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(adds());
        hashCode = 31 * hashCode + Objects.hashCode(deletes());
        hashCode = 31 * hashCode + Objects.hashCode(warnings());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadDocumentsResponse)) {
            return false;
        }
        UploadDocumentsResponse other = (UploadDocumentsResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(adds(), other.adds())
                && Objects.equals(deletes(), other.deletes()) && Objects.equals(warnings(), other.warnings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UploadDocumentsResponse").add("Status", status()).add("Adds", adds()).add("Deletes", deletes())
                .add("Warnings", warnings()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "status":
            return Optional.ofNullable(clazz.cast(status()));
        case "adds":
            return Optional.ofNullable(clazz.cast(adds()));
        case "deletes":
            return Optional.ofNullable(clazz.cast(deletes()));
        case "warnings":
            return Optional.ofNullable(clazz.cast(warnings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadDocumentsResponse, T> g) {
        return obj -> g.apply((UploadDocumentsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchDomainResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UploadDocumentsResponse> {
        /**
         * <p>
         * The status of an <code>UploadDocumentsRequest</code>.
         * </p>
         * 
         * @param status
         *        The status of an <code>UploadDocumentsRequest</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The number of documents that were added to the search domain.
         * </p>
         * 
         * @param adds
         *        The number of documents that were added to the search domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adds(Long adds);

        /**
         * <p>
         * The number of documents that were deleted from the search domain.
         * </p>
         * 
         * @param deletes
         *        The number of documents that were deleted from the search domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deletes(Long deletes);

        /**
         * <p>
         * Any warnings returned by the document service about the documents being uploaded.
         * </p>
         * 
         * @param warnings
         *        Any warnings returned by the document service about the documents being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(Collection<DocumentServiceWarning> warnings);

        /**
         * <p>
         * Any warnings returned by the document service about the documents being uploaded.
         * </p>
         * 
         * @param warnings
         *        Any warnings returned by the document service about the documents being uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warnings(DocumentServiceWarning... warnings);

        /**
         * <p>
         * Any warnings returned by the document service about the documents being uploaded.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DocumentServiceWarning>.Builder} avoiding
         * the need to create one manually via {@link List<DocumentServiceWarning>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DocumentServiceWarning>.Builder#build()} is called
         * immediately and its result is passed to {@link #warnings(List<DocumentServiceWarning>)}.
         * 
         * @param warnings
         *        a consumer that will call methods on {@link List<DocumentServiceWarning>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #warnings(List<DocumentServiceWarning>)
         */
        Builder warnings(Consumer<DocumentServiceWarning.Builder>... warnings);
    }

    static final class BuilderImpl extends CloudSearchDomainResponse.BuilderImpl implements Builder {
        private String status;

        private Long adds;

        private Long deletes;

        private List<DocumentServiceWarning> warnings = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UploadDocumentsResponse model) {
            super(model);
            status(model.status);
            adds(model.adds);
            deletes(model.deletes);
            warnings(model.warnings);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Long getAdds() {
            return adds;
        }

        @Override
        public final Builder adds(Long adds) {
            this.adds = adds;
            return this;
        }

        public final void setAdds(Long adds) {
            this.adds = adds;
        }

        public final Long getDeletes() {
            return deletes;
        }

        @Override
        public final Builder deletes(Long deletes) {
            this.deletes = deletes;
            return this;
        }

        public final void setDeletes(Long deletes) {
            this.deletes = deletes;
        }

        public final Collection<DocumentServiceWarning.Builder> getWarnings() {
            return warnings != null ? warnings.stream().map(DocumentServiceWarning::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder warnings(Collection<DocumentServiceWarning> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copy(warnings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(DocumentServiceWarning... warnings) {
            warnings(Arrays.asList(warnings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder warnings(Consumer<DocumentServiceWarning.Builder>... warnings) {
            warnings(Stream.of(warnings).map(c -> DocumentServiceWarning.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setWarnings(Collection<DocumentServiceWarning.BuilderImpl> warnings) {
            this.warnings = DocumentServiceWarningsCopier.copyFromBuilder(warnings);
        }

        @Override
        public UploadDocumentsResponse build() {
            return new UploadDocumentsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
