/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a document that matches the search request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Hit implements SdkPojo, Serializable, ToCopyableBuilder<Hit.Builder, Hit> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).getter(getter(Hit::id))
            .setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Map<String, List<String>>> FIELDS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .getter(getter(Hit::fields))
            .setter(setter(Builder::fields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fields").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<Map<String, String>> EXPRS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Hit::exprs))
            .setter(setter(Builder::exprs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exprs").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> HIGHLIGHTS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Hit::highlights))
            .setter(setter(Builder::highlights))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("highlights").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, FIELDS_FIELD,
            EXPRS_FIELD, HIGHLIGHTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final Map<String, List<String>> fields;

    private final Map<String, String> exprs;

    private final Map<String, String> highlights;

    private Hit(BuilderImpl builder) {
        this.id = builder.id;
        this.fields = builder.fields;
        this.exprs = builder.exprs;
        this.highlights = builder.highlights;
    }

    /**
     * <p>
     * The document ID of a document that matches the search request.
     * </p>
     * 
     * @return The document ID of a document that matches the search request.
     */
    public String id() {
        return id;
    }

    /**
     * Returns true if the Fields property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFields() {
        return fields != null && !(fields instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The fields returned from a document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFields()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The fields returned from a document that matches the search request.
     */
    public Map<String, List<String>> fields() {
        return fields;
    }

    /**
     * Returns true if the Exprs property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasExprs() {
        return exprs != null && !(exprs instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The expressions returned from a document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasExprs()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The expressions returned from a document that matches the search request.
     */
    public Map<String, String> exprs() {
        return exprs;
    }

    /**
     * Returns true if the Highlights property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasHighlights() {
        return highlights != null && !(highlights instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The highlights returned from a document that matches the search request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasHighlights()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The highlights returned from a document that matches the search request.
     */
    public Map<String, String> highlights() {
        return highlights;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(fields());
        hashCode = 31 * hashCode + Objects.hashCode(exprs());
        hashCode = 31 * hashCode + Objects.hashCode(highlights());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Hit)) {
            return false;
        }
        Hit other = (Hit) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(fields(), other.fields())
                && Objects.equals(exprs(), other.exprs()) && Objects.equals(highlights(), other.highlights());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Hit").add("Id", id()).add("Fields", fields()).add("Exprs", exprs())
                .add("Highlights", highlights()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "fields":
            return Optional.ofNullable(clazz.cast(fields()));
        case "exprs":
            return Optional.ofNullable(clazz.cast(exprs()));
        case "highlights":
            return Optional.ofNullable(clazz.cast(highlights()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Hit, T> g) {
        return obj -> g.apply((Hit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Hit> {
        /**
         * <p>
         * The document ID of a document that matches the search request.
         * </p>
         * 
         * @param id
         *        The document ID of a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The fields returned from a document that matches the search request.
         * </p>
         * 
         * @param fields
         *        The fields returned from a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fields(Map<String, ? extends Collection<String>> fields);

        /**
         * <p>
         * The expressions returned from a document that matches the search request.
         * </p>
         * 
         * @param exprs
         *        The expressions returned from a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exprs(Map<String, String> exprs);

        /**
         * <p>
         * The highlights returned from a document that matches the search request.
         * </p>
         * 
         * @param highlights
         *        The highlights returned from a document that matches the search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder highlights(Map<String, String> highlights);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private Map<String, List<String>> fields = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> exprs = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> highlights = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Hit model) {
            id(model.id);
            fields(model.fields);
            exprs(model.exprs);
            highlights(model.highlights);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Map<String, ? extends Collection<String>> getFields() {
            return fields;
        }

        @Override
        public final Builder fields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
            return this;
        }

        public final void setFields(Map<String, ? extends Collection<String>> fields) {
            this.fields = FieldsCopier.copy(fields);
        }

        public final Map<String, String> getExprs() {
            return exprs;
        }

        @Override
        public final Builder exprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
            return this;
        }

        public final void setExprs(Map<String, String> exprs) {
            this.exprs = ExprsCopier.copy(exprs);
        }

        public final Map<String, String> getHighlights() {
            return highlights;
        }

        @Override
        public final Builder highlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
            return this;
        }

        public final void setHighlights(Map<String, String> highlights) {
            this.highlights = HighlightsCopier.copy(highlights);
        }

        @Override
        public Hit build() {
            return new Hit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
