/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The statistics for a field calculated in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldStats implements SdkPojo, Serializable, ToCopyableBuilder<FieldStats.Builder, FieldStats> {
    private static final SdkField<String> MIN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FieldStats::min)).setter(setter(Builder::min))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("min").build()).build();

    private static final SdkField<String> MAX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FieldStats::max)).setter(setter(Builder::max))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("max").build()).build();

    private static final SdkField<Long> COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(FieldStats::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final SdkField<Long> MISSING_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(FieldStats::missing)).setter(setter(Builder::missing))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("missing").build()).build();

    private static final SdkField<Double> SUM_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(FieldStats::sum)).setter(setter(Builder::sum))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sum").build()).build();

    private static final SdkField<Double> SUM_OF_SQUARES_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(FieldStats::sumOfSquares)).setter(setter(Builder::sumOfSquares))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sumOfSquares").build()).build();

    private static final SdkField<String> MEAN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(FieldStats::mean)).setter(setter(Builder::mean))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mean").build()).build();

    private static final SdkField<Double> STDDEV_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(FieldStats::stddev)).setter(setter(Builder::stddev))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stddev").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_FIELD, MAX_FIELD,
            COUNT_FIELD, MISSING_FIELD, SUM_FIELD, SUM_OF_SQUARES_FIELD, MEAN_FIELD, STDDEV_FIELD));

    private static final long serialVersionUID = 1L;

    private final String min;

    private final String max;

    private final Long count;

    private final Long missing;

    private final Double sum;

    private final Double sumOfSquares;

    private final String mean;

    private final Double stddev;

    private FieldStats(BuilderImpl builder) {
        this.min = builder.min;
        this.max = builder.max;
        this.count = builder.count;
        this.missing = builder.missing;
        this.sum = builder.sum;
        this.sumOfSquares = builder.sumOfSquares;
        this.mean = builder.mean;
        this.stddev = builder.stddev;
    }

    /**
     * <p>
     * The minimum value found in the specified field in the result set.
     * </p>
     * <p>
     * If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
     * <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit floating
     * point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code> is the string
     * representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF
     * RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
     * </p>
     * 
     * @return The minimum value found in the specified field in the result set.</p>
     *         <p>
     *         If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
     *         <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit
     *         floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code> is
     *         the string representation of a date with the format specified in <a
     *         href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
     */
    public String min() {
        return min;
    }

    /**
     * <p>
     * The maximum value found in the specified field in the result set.
     * </p>
     * <p>
     * If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
     * <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit floating
     * point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code> is the string
     * representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF
     * RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
     * </p>
     * 
     * @return The maximum value found in the specified field in the result set.</p>
     *         <p>
     *         If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
     *         <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit
     *         floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code> is
     *         the string representation of a date with the format specified in <a
     *         href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
     */
    public String max() {
        return max;
    }

    /**
     * <p>
     * The number of documents that contain a value in the specified field in the result set.
     * </p>
     * 
     * @return The number of documents that contain a value in the specified field in the result set.
     */
    public Long count() {
        return count;
    }

    /**
     * <p>
     * The number of documents that do not contain a value in the specified field in the result set.
     * </p>
     * 
     * @return The number of documents that do not contain a value in the specified field in the result set.
     */
    public Long missing() {
        return missing;
    }

    /**
     * <p>
     * The sum of the field values across the documents in the result set. <code>null</code> for date fields.
     * </p>
     * 
     * @return The sum of the field values across the documents in the result set. <code>null</code> for date fields.
     */
    public Double sum() {
        return sum;
    }

    /**
     * <p>
     * The sum of all field values in the result set squared.
     * </p>
     * 
     * @return The sum of all field values in the result set squared.
     */
    public Double sumOfSquares() {
        return sumOfSquares;
    }

    /**
     * <p>
     * The average of the values found in the specified field in the result set.
     * </p>
     * <p>
     * If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
     * <code>double-array</code>), <code>mean</code> is the string representation of a double-precision 64-bit floating
     * point value. If the field is <code>date</code> or <code>date-array</code>, <code>mean</code> is the string
     * representation of a date with the format specified in <a href="http://tools.ietf.org/html/rfc3339">IETF
     * RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
     * </p>
     * 
     * @return The average of the values found in the specified field in the result set.</p>
     *         <p>
     *         If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
     *         <code>double-array</code>), <code>mean</code> is the string representation of a double-precision 64-bit
     *         floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>mean</code> is
     *         the string representation of a date with the format specified in <a
     *         href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
     */
    public String mean() {
        return mean;
    }

    /**
     * <p>
     * The standard deviation of the values in the specified field in the result set.
     * </p>
     * 
     * @return The standard deviation of the values in the specified field in the result set.
     */
    public Double stddev() {
        return stddev;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(min());
        hashCode = 31 * hashCode + Objects.hashCode(max());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(missing());
        hashCode = 31 * hashCode + Objects.hashCode(sum());
        hashCode = 31 * hashCode + Objects.hashCode(sumOfSquares());
        hashCode = 31 * hashCode + Objects.hashCode(mean());
        hashCode = 31 * hashCode + Objects.hashCode(stddev());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldStats)) {
            return false;
        }
        FieldStats other = (FieldStats) obj;
        return Objects.equals(min(), other.min()) && Objects.equals(max(), other.max()) && Objects.equals(count(), other.count())
                && Objects.equals(missing(), other.missing()) && Objects.equals(sum(), other.sum())
                && Objects.equals(sumOfSquares(), other.sumOfSquares()) && Objects.equals(mean(), other.mean())
                && Objects.equals(stddev(), other.stddev());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("FieldStats").add("Min", min()).add("Max", max()).add("Count", count()).add("Missing", missing())
                .add("Sum", sum()).add("SumOfSquares", sumOfSquares()).add("Mean", mean()).add("Stddev", stddev()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "min":
            return Optional.ofNullable(clazz.cast(min()));
        case "max":
            return Optional.ofNullable(clazz.cast(max()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        case "missing":
            return Optional.ofNullable(clazz.cast(missing()));
        case "sum":
            return Optional.ofNullable(clazz.cast(sum()));
        case "sumOfSquares":
            return Optional.ofNullable(clazz.cast(sumOfSquares()));
        case "mean":
            return Optional.ofNullable(clazz.cast(mean()));
        case "stddev":
            return Optional.ofNullable(clazz.cast(stddev()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldStats, T> g) {
        return obj -> g.apply((FieldStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldStats> {
        /**
         * <p>
         * The minimum value found in the specified field in the result set.
         * </p>
         * <p>
         * If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
         * <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit
         * floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code> is the
         * string representation of a date with the format specified in <a
         * href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
         * </p>
         * 
         * @param min
         *        The minimum value found in the specified field in the result set.</p>
         *        <p>
         *        If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
         *        <code>double-array</code>), <code>min</code> is the string representation of a double-precision 64-bit
         *        floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>min</code>
         *        is the string representation of a date with the format specified in <a
         *        href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder min(String min);

        /**
         * <p>
         * The maximum value found in the specified field in the result set.
         * </p>
         * <p>
         * If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
         * <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit
         * floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code> is the
         * string representation of a date with the format specified in <a
         * href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
         * </p>
         * 
         * @param max
         *        The maximum value found in the specified field in the result set.</p>
         *        <p>
         *        If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
         *        <code>double-array</code>), <code>max</code> is the string representation of a double-precision 64-bit
         *        floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>max</code>
         *        is the string representation of a date with the format specified in <a
         *        href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder max(String max);

        /**
         * <p>
         * The number of documents that contain a value in the specified field in the result set.
         * </p>
         * 
         * @param count
         *        The number of documents that contain a value in the specified field in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Long count);

        /**
         * <p>
         * The number of documents that do not contain a value in the specified field in the result set.
         * </p>
         * 
         * @param missing
         *        The number of documents that do not contain a value in the specified field in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder missing(Long missing);

        /**
         * <p>
         * The sum of the field values across the documents in the result set. <code>null</code> for date fields.
         * </p>
         * 
         * @param sum
         *        The sum of the field values across the documents in the result set. <code>null</code> for date fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sum(Double sum);

        /**
         * <p>
         * The sum of all field values in the result set squared.
         * </p>
         * 
         * @param sumOfSquares
         *        The sum of all field values in the result set squared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sumOfSquares(Double sumOfSquares);

        /**
         * <p>
         * The average of the values found in the specified field in the result set.
         * </p>
         * <p>
         * If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
         * <code>double-array</code>), <code>mean</code> is the string representation of a double-precision 64-bit
         * floating point value. If the field is <code>date</code> or <code>date-array</code>, <code>mean</code> is the
         * string representation of a date with the format specified in <a
         * href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
         * </p>
         * 
         * @param mean
         *        The average of the values found in the specified field in the result set.</p>
         *        <p>
         *        If the field is numeric (<code>int</code>, <code>int-array</code>, <code>double</code>, or
         *        <code>double-array</code>), <code>mean</code> is the string representation of a double-precision
         *        64-bit floating point value. If the field is <code>date</code> or <code>date-array</code>,
         *        <code>mean</code> is the string representation of a date with the format specified in <a
         *        href="http://tools.ietf.org/html/rfc3339">IETF RFC3339</a>: yyyy-mm-ddTHH:mm:ss.SSSZ.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mean(String mean);

        /**
         * <p>
         * The standard deviation of the values in the specified field in the result set.
         * </p>
         * 
         * @param stddev
         *        The standard deviation of the values in the specified field in the result set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stddev(Double stddev);
    }

    static final class BuilderImpl implements Builder {
        private String min;

        private String max;

        private Long count;

        private Long missing;

        private Double sum;

        private Double sumOfSquares;

        private String mean;

        private Double stddev;

        private BuilderImpl() {
        }

        private BuilderImpl(FieldStats model) {
            min(model.min);
            max(model.max);
            count(model.count);
            missing(model.missing);
            sum(model.sum);
            sumOfSquares(model.sumOfSquares);
            mean(model.mean);
            stddev(model.stddev);
        }

        public final String getMin() {
            return min;
        }

        @Override
        public final Builder min(String min) {
            this.min = min;
            return this;
        }

        public final void setMin(String min) {
            this.min = min;
        }

        public final String getMax() {
            return max;
        }

        @Override
        public final Builder max(String max) {
            this.max = max;
            return this;
        }

        public final void setMax(String max) {
            this.max = max;
        }

        public final Long getCount() {
            return count;
        }

        @Override
        public final Builder count(Long count) {
            this.count = count;
            return this;
        }

        public final void setCount(Long count) {
            this.count = count;
        }

        public final Long getMissing() {
            return missing;
        }

        @Override
        public final Builder missing(Long missing) {
            this.missing = missing;
            return this;
        }

        public final void setMissing(Long missing) {
            this.missing = missing;
        }

        public final Double getSum() {
            return sum;
        }

        @Override
        public final Builder sum(Double sum) {
            this.sum = sum;
            return this;
        }

        public final void setSum(Double sum) {
            this.sum = sum;
        }

        public final Double getSumOfSquares() {
            return sumOfSquares;
        }

        @Override
        public final Builder sumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
            return this;
        }

        public final void setSumOfSquares(Double sumOfSquares) {
            this.sumOfSquares = sumOfSquares;
        }

        public final String getMean() {
            return mean;
        }

        @Override
        public final Builder mean(String mean) {
            this.mean = mean;
            return this;
        }

        public final void setMean(String mean) {
            this.mean = mean;
        }

        public final Double getStddev() {
            return stddev;
        }

        @Override
        public final Builder stddev(Double stddev) {
            this.stddev = stddev;
            return this;
        }

        public final void setStddev(Double stddev) {
            this.stddev = stddev;
        }

        @Override
        public FieldStats build() {
            return new FieldStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
