/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the resource id (<code>rid</code>) and the time it took to process the request (<code>timems</code>).
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchStatus implements SdkPojo, Serializable, ToCopyableBuilder<SearchStatus.Builder, SearchStatus> {
    private static final SdkField<Long> TIMEMS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(SearchStatus::timems)).setter(setter(Builder::timems))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timems").build()).build();

    private static final SdkField<String> RID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(SearchStatus::rid)).setter(setter(Builder::rid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rid").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEMS_FIELD, RID_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long timems;

    private final String rid;

    private SearchStatus(BuilderImpl builder) {
        this.timems = builder.timems;
        this.rid = builder.rid;
    }

    /**
     * <p>
     * How long it took to process the request, in milliseconds.
     * </p>
     * 
     * @return How long it took to process the request, in milliseconds.
     */
    public Long timems() {
        return timems;
    }

    /**
     * <p>
     * The encrypted resource ID for the request.
     * </p>
     * 
     * @return The encrypted resource ID for the request.
     */
    public String rid() {
        return rid;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timems());
        hashCode = 31 * hashCode + Objects.hashCode(rid());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchStatus)) {
            return false;
        }
        SearchStatus other = (SearchStatus) obj;
        return Objects.equals(timems(), other.timems()) && Objects.equals(rid(), other.rid());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("SearchStatus").add("Timems", timems()).add("Rid", rid()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timems":
            return Optional.ofNullable(clazz.cast(timems()));
        case "rid":
            return Optional.ofNullable(clazz.cast(rid()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SearchStatus, T> g) {
        return obj -> g.apply((SearchStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SearchStatus> {
        /**
         * <p>
         * How long it took to process the request, in milliseconds.
         * </p>
         * 
         * @param timems
         *        How long it took to process the request, in milliseconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timems(Long timems);

        /**
         * <p>
         * The encrypted resource ID for the request.
         * </p>
         * 
         * @param rid
         *        The encrypted resource ID for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rid(String rid);
    }

    static final class BuilderImpl implements Builder {
        private Long timems;

        private String rid;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchStatus model) {
            timems(model.timems);
            rid(model.rid);
        }

        public final Long getTimems() {
            return timems;
        }

        @Override
        public final Builder timems(Long timems) {
            this.timems = timems;
            return this;
        }

        public final void setTimems(Long timems) {
            this.timems = timems;
        }

        public final String getRid() {
            return rid;
        }

        @Override
        public final Builder rid(String rid) {
            this.rid = rid;
            return this;
        }

        public final void setRid(String rid) {
            this.rid = rid;
        }

        @Override
        public SearchStatus build() {
            return new SearchStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
