/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.http.SdkHttpFullRequest;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkProtectedApi
public final class SwitchToPostInterceptor
implements ExecutionInterceptor {
    public SdkHttpFullRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpFullRequest request = context.httpRequest();
        SdkRequest originalRequest = context.request();
        if (originalRequest instanceof SearchRequest && request.method() == SdkHttpMethod.GET) {
            return (SdkHttpFullRequest)((SdkHttpFullRequest.Builder)((SdkHttpFullRequest.Builder)request.toBuilder()).method(SdkHttpMethod.POST).applyMutation(SwitchToPostInterceptor::changeQueryParametersToFormData)).build();
        }
        return request;
    }

    private static SdkHttpFullRequest.Builder changeQueryParametersToFormData(SdkHttpFullRequest.Builder input) {
        byte[] params = SdkHttpUtils.encodeAndFlattenFormData((Map)input.rawQueryParameters()).orElse("").getBytes(StandardCharsets.UTF_8);
        return input.clearQueryParameters().contentStreamProvider(() -> new ByteArrayInputStream(params)).putHeader("Content-Length", Collections.singletonList(String.valueOf(params.length))).putHeader("Content-Type", Collections.singletonList("application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase((String)StandardCharsets.UTF_8.toString())));
    }
}

