/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeStatus;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeStatusListCopier;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAnalysisSchemesResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeAnalysisSchemesResponse> {
    private static final SdkField<List<AnalysisSchemeStatus>> ANALYSIS_SCHEMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeAnalysisSchemesResponse.getter(DescribeAnalysisSchemesResponse::analysisSchemes)).setter(DescribeAnalysisSchemesResponse.setter(Builder::analysisSchemes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalysisSchemeStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SCHEMES_FIELD));
    private final List<AnalysisSchemeStatus> analysisSchemes;

    private DescribeAnalysisSchemesResponse(BuilderImpl builder) {
        super(builder);
        this.analysisSchemes = builder.analysisSchemes;
    }

    public List<AnalysisSchemeStatus> analysisSchemes() {
        return this.analysisSchemes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisSchemesResponse)) {
            return false;
        }
        DescribeAnalysisSchemesResponse other = (DescribeAnalysisSchemesResponse)((Object)obj);
        return Objects.equals(this.analysisSchemes(), other.analysisSchemes());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAnalysisSchemesResponse").add("AnalysisSchemes", this.analysisSchemes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSchemes": {
                return Optional.ofNullable(clazz.cast(this.analysisSchemes()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnalysisSchemesResponse, T> g) {
        return obj -> g.apply((DescribeAnalysisSchemesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<AnalysisSchemeStatus> analysisSchemes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisSchemesResponse model) {
            super(model);
            this.analysisSchemes(model.analysisSchemes);
        }

        public final Collection<AnalysisSchemeStatus.Builder> getAnalysisSchemes() {
            return this.analysisSchemes != null ? (Collection)this.analysisSchemes.stream().map(AnalysisSchemeStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder analysisSchemes(Collection<AnalysisSchemeStatus> analysisSchemes) {
            this.analysisSchemes = AnalysisSchemeStatusListCopier.copy(analysisSchemes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSchemes(AnalysisSchemeStatus ... analysisSchemes) {
            this.analysisSchemes(Arrays.asList(analysisSchemes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSchemes(Consumer<AnalysisSchemeStatus.Builder> ... analysisSchemes) {
            this.analysisSchemes(Stream.of(analysisSchemes).map(c -> (AnalysisSchemeStatus)((AnalysisSchemeStatus.Builder)AnalysisSchemeStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnalysisSchemes(Collection<AnalysisSchemeStatus.BuilderImpl> analysisSchemes) {
            this.analysisSchemes = AnalysisSchemeStatusListCopier.copyFromBuilder(analysisSchemes);
        }

        @Override
        public DescribeAnalysisSchemesResponse build() {
            return new DescribeAnalysisSchemesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAnalysisSchemesResponse> {
        public Builder analysisSchemes(Collection<AnalysisSchemeStatus> var1);

        public Builder analysisSchemes(AnalysisSchemeStatus ... var1);

        public Builder analysisSchemes(Consumer<AnalysisSchemeStatus.Builder> ... var1);
    }
}

