/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClient;
import software.amazon.awssdk.services.cloudsearch.model.BaseException;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchException;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsRequest;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsResponse;
import software.amazon.awssdk.services.cloudsearch.model.InternalException;
import software.amazon.awssdk.services.cloudsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.cloudsearch.model.LimitExceededException;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.cloudsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.ValidationException;
import software.amazon.awssdk.services.cloudsearch.transform.BuildSuggestersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineAnalysisSchemeRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineExpressionRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineIndexFieldRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineSuggesterRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteAnalysisSchemeRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteExpressionRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteIndexFieldRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteSuggesterRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAnalysisSchemesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAvailabilityOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeDomainEndpointOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeDomainsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeExpressionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeIndexFieldsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeScalingParametersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeSuggestersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.IndexDocumentsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateAvailabilityOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateDomainEndpointOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateScalingParametersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateServiceAccessPoliciesRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultCloudSearchClient
implements CloudSearchClient {
    private static final Logger log = Logger.loggerFor(DefaultCloudSearchClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudSearchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "cloudsearch";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildSuggestersResponse buildSuggesters(BuildSuggestersRequest buildSuggestersRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BuildSuggestersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, buildSuggestersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"BuildSuggesters");
            BuildSuggestersResponse buildSuggestersResponse = (BuildSuggestersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BuildSuggesters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)buildSuggestersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new BuildSuggestersRequestMarshaller(this.protocolFactory)));
            return buildSuggestersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$buildSuggesters$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws BaseException, InternalException, LimitExceededException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDomainResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, createDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateDomain");
            CreateDomainResponse createDomainResponse = (CreateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateDomainRequestMarshaller(this.protocolFactory)));
            return createDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$createDomain$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineAnalysisSchemeResponse defineAnalysisScheme(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineAnalysisSchemeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, defineAnalysisSchemeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DefineAnalysisScheme");
            DefineAnalysisSchemeResponse defineAnalysisSchemeResponse = (DefineAnalysisSchemeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineAnalysisScheme").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineAnalysisSchemeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DefineAnalysisSchemeRequestMarshaller(this.protocolFactory)));
            return defineAnalysisSchemeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$defineAnalysisScheme$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineExpressionResponse defineExpression(DefineExpressionRequest defineExpressionRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineExpressionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, defineExpressionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DefineExpression");
            DefineExpressionResponse defineExpressionResponse = (DefineExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineExpression").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineExpressionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DefineExpressionRequestMarshaller(this.protocolFactory)));
            return defineExpressionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$defineExpression$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineIndexFieldResponse defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineIndexFieldResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, defineIndexFieldRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DefineIndexField");
            DefineIndexFieldResponse defineIndexFieldResponse = (DefineIndexFieldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineIndexField").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineIndexFieldRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DefineIndexFieldRequestMarshaller(this.protocolFactory)));
            return defineIndexFieldResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$defineIndexField$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefineSuggesterResponse defineSuggester(DefineSuggesterRequest defineSuggesterRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineSuggesterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, defineSuggesterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DefineSuggester");
            DefineSuggesterResponse defineSuggesterResponse = (DefineSuggesterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineSuggester").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineSuggesterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DefineSuggesterRequestMarshaller(this.protocolFactory)));
            return defineSuggesterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$defineSuggester$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnalysisSchemeResponse deleteAnalysisScheme(DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAnalysisSchemeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, deleteAnalysisSchemeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnalysisScheme");
            DeleteAnalysisSchemeResponse deleteAnalysisSchemeResponse = (DeleteAnalysisSchemeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnalysisScheme").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAnalysisSchemeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnalysisSchemeRequestMarshaller(this.protocolFactory)));
            return deleteAnalysisSchemeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$deleteAnalysisScheme$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws BaseException, InternalException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDomainResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, deleteDomainRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDomain");
            DeleteDomainResponse deleteDomainResponse = (DeleteDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDomainRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller(this.protocolFactory)));
            return deleteDomainResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$deleteDomain$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteExpressionResponse deleteExpression(DeleteExpressionRequest deleteExpressionRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteExpressionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, deleteExpressionRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteExpression");
            DeleteExpressionResponse deleteExpressionResponse = (DeleteExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteExpression").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteExpressionRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteExpressionRequestMarshaller(this.protocolFactory)));
            return deleteExpressionResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$deleteExpression$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteIndexFieldResponse deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteIndexFieldResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, deleteIndexFieldRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteIndexField");
            DeleteIndexFieldResponse deleteIndexFieldResponse = (DeleteIndexFieldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIndexField").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIndexFieldRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteIndexFieldRequestMarshaller(this.protocolFactory)));
            return deleteIndexFieldResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$deleteIndexField$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteSuggesterResponse deleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSuggesterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, deleteSuggesterRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteSuggester");
            DeleteSuggesterResponse deleteSuggesterResponse = (DeleteSuggesterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSuggester").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSuggesterRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteSuggesterRequestMarshaller(this.protocolFactory)));
            return deleteSuggesterResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$deleteSuggester$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAnalysisSchemesResponse describeAnalysisSchemes(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAnalysisSchemesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeAnalysisSchemesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAnalysisSchemes");
            DescribeAnalysisSchemesResponse describeAnalysisSchemesResponse = (DescribeAnalysisSchemesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnalysisSchemes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAnalysisSchemesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAnalysisSchemesRequestMarshaller(this.protocolFactory)));
            return describeAnalysisSchemesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeAnalysisSchemes$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeAvailabilityOptionsResponse describeAvailabilityOptions(DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAvailabilityOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeAvailabilityOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAvailabilityOptions");
            DescribeAvailabilityOptionsResponse describeAvailabilityOptionsResponse = (DescribeAvailabilityOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAvailabilityOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAvailabilityOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeAvailabilityOptionsRequestMarshaller(this.protocolFactory)));
            return describeAvailabilityOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeAvailabilityOptions$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainEndpointOptionsResponse describeDomainEndpointOptions(DescribeDomainEndpointOptionsRequest describeDomainEndpointOptionsRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDomainEndpointOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeDomainEndpointOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomainEndpointOptions");
            DescribeDomainEndpointOptionsResponse describeDomainEndpointOptionsResponse = (DescribeDomainEndpointOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainEndpointOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainEndpointOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainEndpointOptionsRequestMarshaller(this.protocolFactory)));
            return describeDomainEndpointOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeDomainEndpointOptions$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeDomainsResponse describeDomains(DescribeDomainsRequest describeDomainsRequest) throws BaseException, InternalException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDomainsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeDomainsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeDomains");
            DescribeDomainsResponse describeDomainsResponse = (DescribeDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeDomainsRequestMarshaller(this.protocolFactory)));
            return describeDomainsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeDomains$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeExpressionsResponse describeExpressions(DescribeExpressionsRequest describeExpressionsRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeExpressionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeExpressionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeExpressions");
            DescribeExpressionsResponse describeExpressionsResponse = (DescribeExpressionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExpressions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExpressionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeExpressionsRequestMarshaller(this.protocolFactory)));
            return describeExpressionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeExpressions$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeIndexFieldsResponse describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeIndexFieldsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeIndexFieldsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeIndexFields");
            DescribeIndexFieldsResponse describeIndexFieldsResponse = (DescribeIndexFieldsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIndexFields").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIndexFieldsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeIndexFieldsRequestMarshaller(this.protocolFactory)));
            return describeIndexFieldsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeIndexFields$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeScalingParametersResponse describeScalingParameters(DescribeScalingParametersRequest describeScalingParametersRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeScalingParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeScalingParameters");
            DescribeScalingParametersResponse describeScalingParametersResponse = (DescribeScalingParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeScalingParametersRequestMarshaller(this.protocolFactory)));
            return describeScalingParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeScalingParameters$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeServiceAccessPoliciesResponse describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeServiceAccessPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeServiceAccessPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeServiceAccessPolicies");
            DescribeServiceAccessPoliciesResponse describeServiceAccessPoliciesResponse = (DescribeServiceAccessPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceAccessPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServiceAccessPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeServiceAccessPoliciesRequestMarshaller(this.protocolFactory)));
            return describeServiceAccessPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeServiceAccessPolicies$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeSuggestersResponse describeSuggesters(DescribeSuggestersRequest describeSuggestersRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSuggestersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, describeSuggestersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeSuggesters");
            DescribeSuggestersResponse describeSuggestersResponse = (DescribeSuggestersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSuggesters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSuggestersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DescribeSuggestersRequestMarshaller(this.protocolFactory)));
            return describeSuggestersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$describeSuggesters$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexDocumentsResponse indexDocuments(IndexDocumentsRequest indexDocumentsRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(IndexDocumentsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, indexDocumentsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"IndexDocuments");
            IndexDocumentsResponse indexDocumentsResponse = (IndexDocumentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IndexDocuments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)indexDocumentsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new IndexDocumentsRequestMarshaller(this.protocolFactory)));
            return indexDocumentsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$indexDocuments$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListDomainNamesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, listDomainNamesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDomainNames");
            ListDomainNamesResponse listDomainNamesResponse = (ListDomainNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainNames").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainNamesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller(this.protocolFactory)));
            return listDomainNamesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$listDomainNames$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateAvailabilityOptionsResponse updateAvailabilityOptions(UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAvailabilityOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, updateAvailabilityOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateAvailabilityOptions");
            UpdateAvailabilityOptionsResponse updateAvailabilityOptionsResponse = (UpdateAvailabilityOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAvailabilityOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAvailabilityOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateAvailabilityOptionsRequestMarshaller(this.protocolFactory)));
            return updateAvailabilityOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$updateAvailabilityOptions$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateDomainEndpointOptionsResponse updateDomainEndpointOptions(UpdateDomainEndpointOptionsRequest updateDomainEndpointOptionsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateDomainEndpointOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, updateDomainEndpointOptionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateDomainEndpointOptions");
            UpdateDomainEndpointOptionsResponse updateDomainEndpointOptionsResponse = (UpdateDomainEndpointOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainEndpointOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDomainEndpointOptionsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateDomainEndpointOptionsRequestMarshaller(this.protocolFactory)));
            return updateDomainEndpointOptionsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$updateDomainEndpointOptions$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateScalingParametersResponse updateScalingParameters(UpdateScalingParametersRequest updateScalingParametersRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, InvalidTypeException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateScalingParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, updateScalingParametersRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateScalingParameters");
            UpdateScalingParametersResponse updateScalingParametersResponse = (UpdateScalingParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScalingParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateScalingParametersRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateScalingParametersRequestMarshaller(this.protocolFactory)));
            return updateScalingParametersResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$updateScalingParameters$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateServiceAccessPoliciesResponse updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, InvalidTypeException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateServiceAccessPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        List<MetricPublisher> metricPublishers = DefaultCloudSearchClient.resolveMetricPublishers(this.clientConfiguration, updateServiceAccessPoliciesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudSearch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateServiceAccessPolicies");
            UpdateServiceAccessPoliciesResponse updateServiceAccessPoliciesResponse = (UpdateServiceAccessPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceAccessPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceAccessPoliciesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateServiceAccessPoliciesRequestMarshaller(this.protocolFactory)));
            return updateServiceAccessPoliciesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultCloudSearchClient.lambda$updateServiceAccessPolicies$25((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DisabledAction").exceptionBuilderSupplier(DisabledOperationException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidType").exceptionBuilderSupplier(InvalidTypeException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudSearchException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudSearchRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.16.5").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudSearchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateServiceAccessPolicies$25(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateScalingParameters$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateDomainEndpointOptions$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateAvailabilityOptions$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDomainNames$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$indexDocuments$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeSuggesters$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeServiceAccessPolicies$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeScalingParameters$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeIndexFields$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeExpressions$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomains$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeDomainEndpointOptions$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAvailabilityOptions$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAnalysisSchemes$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteSuggester$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteIndexField$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteExpression$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDomain$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnalysisScheme$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$defineSuggester$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$defineIndexField$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$defineExpression$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$defineAnalysisScheme$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createDomain$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$buildSuggesters$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

