/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The desired instance type and desired number of replicas of each index partition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScalingParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<ScalingParameters.Builder, ScalingParameters> {
    private static final SdkField<String> DESIRED_INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredInstanceType").getter(getter(ScalingParameters::desiredInstanceTypeAsString))
            .setter(setter(Builder::desiredInstanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstanceType").build())
            .build();

    private static final SdkField<Integer> DESIRED_REPLICATION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredReplicationCount").getter(getter(ScalingParameters::desiredReplicationCount))
            .setter(setter(Builder::desiredReplicationCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredReplicationCount").build())
            .build();

    private static final SdkField<Integer> DESIRED_PARTITION_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredPartitionCount").getter(getter(ScalingParameters::desiredPartitionCount))
            .setter(setter(Builder::desiredPartitionCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredPartitionCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_INSTANCE_TYPE_FIELD,
            DESIRED_REPLICATION_COUNT_FIELD, DESIRED_PARTITION_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String desiredInstanceType;

    private final Integer desiredReplicationCount;

    private final Integer desiredPartitionCount;

    private ScalingParameters(BuilderImpl builder) {
        this.desiredInstanceType = builder.desiredInstanceType;
        this.desiredReplicationCount = builder.desiredReplicationCount;
        this.desiredPartitionCount = builder.desiredPartitionCount;
    }

    /**
     * <p>
     * The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #desiredInstanceType} will return {@link PartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #desiredInstanceTypeAsString}.
     * </p>
     * 
     * @return The instance type that you want to preconfigure for your domain. For example,
     *         <code>search.m1.small</code>.
     * @see PartitionInstanceType
     */
    public final PartitionInstanceType desiredInstanceType() {
        return PartitionInstanceType.fromValue(desiredInstanceType);
    }

    /**
     * <p>
     * The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #desiredInstanceType} will return {@link PartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #desiredInstanceTypeAsString}.
     * </p>
     * 
     * @return The instance type that you want to preconfigure for your domain. For example,
     *         <code>search.m1.small</code>.
     * @see PartitionInstanceType
     */
    public final String desiredInstanceTypeAsString() {
        return desiredInstanceType;
    }

    /**
     * <p>
     * The number of replicas you want to preconfigure for each index partition.
     * </p>
     * 
     * @return The number of replicas you want to preconfigure for each index partition.
     */
    public final Integer desiredReplicationCount() {
        return desiredReplicationCount;
    }

    /**
     * <p>
     * The number of partitions you want to preconfigure for your domain. Only valid when you select
     * <code>m2.2xlarge</code> as the desired instance type.
     * </p>
     * 
     * @return The number of partitions you want to preconfigure for your domain. Only valid when you select
     *         <code>m2.2xlarge</code> as the desired instance type.
     */
    public final Integer desiredPartitionCount() {
        return desiredPartitionCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredInstanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(desiredReplicationCount());
        hashCode = 31 * hashCode + Objects.hashCode(desiredPartitionCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScalingParameters)) {
            return false;
        }
        ScalingParameters other = (ScalingParameters) obj;
        return Objects.equals(desiredInstanceTypeAsString(), other.desiredInstanceTypeAsString())
                && Objects.equals(desiredReplicationCount(), other.desiredReplicationCount())
                && Objects.equals(desiredPartitionCount(), other.desiredPartitionCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScalingParameters").add("DesiredInstanceType", desiredInstanceTypeAsString())
                .add("DesiredReplicationCount", desiredReplicationCount()).add("DesiredPartitionCount", desiredPartitionCount())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredInstanceType":
            return Optional.ofNullable(clazz.cast(desiredInstanceTypeAsString()));
        case "DesiredReplicationCount":
            return Optional.ofNullable(clazz.cast(desiredReplicationCount()));
        case "DesiredPartitionCount":
            return Optional.ofNullable(clazz.cast(desiredPartitionCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScalingParameters, T> g) {
        return obj -> g.apply((ScalingParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScalingParameters> {
        /**
         * <p>
         * The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.
         * </p>
         * 
         * @param desiredInstanceType
         *        The instance type that you want to preconfigure for your domain. For example,
         *        <code>search.m1.small</code>.
         * @see PartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionInstanceType
         */
        Builder desiredInstanceType(String desiredInstanceType);

        /**
         * <p>
         * The instance type that you want to preconfigure for your domain. For example, <code>search.m1.small</code>.
         * </p>
         * 
         * @param desiredInstanceType
         *        The instance type that you want to preconfigure for your domain. For example,
         *        <code>search.m1.small</code>.
         * @see PartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PartitionInstanceType
         */
        Builder desiredInstanceType(PartitionInstanceType desiredInstanceType);

        /**
         * <p>
         * The number of replicas you want to preconfigure for each index partition.
         * </p>
         * 
         * @param desiredReplicationCount
         *        The number of replicas you want to preconfigure for each index partition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredReplicationCount(Integer desiredReplicationCount);

        /**
         * <p>
         * The number of partitions you want to preconfigure for your domain. Only valid when you select
         * <code>m2.2xlarge</code> as the desired instance type.
         * </p>
         * 
         * @param desiredPartitionCount
         *        The number of partitions you want to preconfigure for your domain. Only valid when you select
         *        <code>m2.2xlarge</code> as the desired instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredPartitionCount(Integer desiredPartitionCount);
    }

    static final class BuilderImpl implements Builder {
        private String desiredInstanceType;

        private Integer desiredReplicationCount;

        private Integer desiredPartitionCount;

        private BuilderImpl() {
        }

        private BuilderImpl(ScalingParameters model) {
            desiredInstanceType(model.desiredInstanceType);
            desiredReplicationCount(model.desiredReplicationCount);
            desiredPartitionCount(model.desiredPartitionCount);
        }

        public final String getDesiredInstanceType() {
            return desiredInstanceType;
        }

        @Override
        public final Builder desiredInstanceType(String desiredInstanceType) {
            this.desiredInstanceType = desiredInstanceType;
            return this;
        }

        @Override
        public final Builder desiredInstanceType(PartitionInstanceType desiredInstanceType) {
            this.desiredInstanceType(desiredInstanceType == null ? null : desiredInstanceType.toString());
            return this;
        }

        public final void setDesiredInstanceType(String desiredInstanceType) {
            this.desiredInstanceType = desiredInstanceType;
        }

        public final Integer getDesiredReplicationCount() {
            return desiredReplicationCount;
        }

        @Override
        public final Builder desiredReplicationCount(Integer desiredReplicationCount) {
            this.desiredReplicationCount = desiredReplicationCount;
            return this;
        }

        public final void setDesiredReplicationCount(Integer desiredReplicationCount) {
            this.desiredReplicationCount = desiredReplicationCount;
        }

        public final Integer getDesiredPartitionCount() {
            return desiredPartitionCount;
        }

        @Override
        public final Builder desiredPartitionCount(Integer desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
            return this;
        }

        public final void setDesiredPartitionCount(Integer desiredPartitionCount) {
            this.desiredPartitionCount = desiredPartitionCount;
        }

        @Override
        public ScalingParameters build() {
            return new ScalingParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
