/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Options for a date field. Dates and times are specified in UTC (Coordinated Universal Time) according to IETF
 * RFC3339: yyyy-mm-ddT00:00:00Z. Present if <code>IndexFieldType</code> specifies the field is of type
 * <code>date</code>. All options are enabled by default.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DateOptions implements SdkPojo, Serializable, ToCopyableBuilder<DateOptions.Builder, DateOptions> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultValue").getter(getter(DateOptions::defaultValue)).setter(setter(Builder::defaultValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValue").build()).build();

    private static final SdkField<String> SOURCE_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SourceField").getter(getter(DateOptions::sourceField)).setter(setter(Builder::sourceField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceField").build()).build();

    private static final SdkField<Boolean> FACET_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("FacetEnabled").getter(getter(DateOptions::facetEnabled)).setter(setter(Builder::facetEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FacetEnabled").build()).build();

    private static final SdkField<Boolean> SEARCH_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SearchEnabled").getter(getter(DateOptions::searchEnabled)).setter(setter(Builder::searchEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SearchEnabled").build()).build();

    private static final SdkField<Boolean> RETURN_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ReturnEnabled").getter(getter(DateOptions::returnEnabled)).setter(setter(Builder::returnEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReturnEnabled").build()).build();

    private static final SdkField<Boolean> SORT_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("SortEnabled").getter(getter(DateOptions::sortEnabled)).setter(setter(Builder::sortEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD,
            SOURCE_FIELD_FIELD, FACET_ENABLED_FIELD, SEARCH_ENABLED_FIELD, RETURN_ENABLED_FIELD, SORT_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String defaultValue;

    private final String sourceField;

    private final Boolean facetEnabled;

    private final Boolean searchEnabled;

    private final Boolean returnEnabled;

    private final Boolean sortEnabled;

    private DateOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceField = builder.sourceField;
        this.facetEnabled = builder.facetEnabled;
        this.searchEnabled = builder.searchEnabled;
        this.returnEnabled = builder.returnEnabled;
        this.sortEnabled = builder.sortEnabled;
    }

    /**
     * A value to use for the field if the field isn't specified for a document.
     * 
     * @return A value to use for the field if the field isn't specified for a document.
     */
    public final String defaultValue() {
        return defaultValue;
    }

    /**
     * Returns the value of the SourceField property for this object.
     * 
     * @return The value of the SourceField property for this object.
     */
    public final String sourceField() {
        return sourceField;
    }

    /**
     * <p>
     * Whether facet information can be returned for the field.
     * </p>
     * 
     * @return Whether facet information can be returned for the field.
     */
    public final Boolean facetEnabled() {
        return facetEnabled;
    }

    /**
     * <p>
     * Whether the contents of the field are searchable.
     * </p>
     * 
     * @return Whether the contents of the field are searchable.
     */
    public final Boolean searchEnabled() {
        return searchEnabled;
    }

    /**
     * <p>
     * Whether the contents of the field can be returned in the search results.
     * </p>
     * 
     * @return Whether the contents of the field can be returned in the search results.
     */
    public final Boolean returnEnabled() {
        return returnEnabled;
    }

    /**
     * <p>
     * Whether the field can be used to sort the search results.
     * </p>
     * 
     * @return Whether the field can be used to sort the search results.
     */
    public final Boolean sortEnabled() {
        return sortEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(facetEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(searchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(sortEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateOptions)) {
            return false;
        }
        DateOptions other = (DateOptions) obj;
        return Objects.equals(defaultValue(), other.defaultValue()) && Objects.equals(sourceField(), other.sourceField())
                && Objects.equals(facetEnabled(), other.facetEnabled()) && Objects.equals(searchEnabled(), other.searchEnabled())
                && Objects.equals(returnEnabled(), other.returnEnabled()) && Objects.equals(sortEnabled(), other.sortEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DateOptions").add("DefaultValue", defaultValue()).add("SourceField", sourceField())
                .add("FacetEnabled", facetEnabled()).add("SearchEnabled", searchEnabled()).add("ReturnEnabled", returnEnabled())
                .add("SortEnabled", sortEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DefaultValue":
            return Optional.ofNullable(clazz.cast(defaultValue()));
        case "SourceField":
            return Optional.ofNullable(clazz.cast(sourceField()));
        case "FacetEnabled":
            return Optional.ofNullable(clazz.cast(facetEnabled()));
        case "SearchEnabled":
            return Optional.ofNullable(clazz.cast(searchEnabled()));
        case "ReturnEnabled":
            return Optional.ofNullable(clazz.cast(returnEnabled()));
        case "SortEnabled":
            return Optional.ofNullable(clazz.cast(sortEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DateOptions, T> g) {
        return obj -> g.apply((DateOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DateOptions> {
        /**
         * A value to use for the field if the field isn't specified for a document.
         * 
         * @param defaultValue
         *        A value to use for the field if the field isn't specified for a document.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValue(String defaultValue);

        /**
         * Sets the value of the SourceField property for this object.
         *
         * @param sourceField
         *        The new value for the SourceField property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceField(String sourceField);

        /**
         * <p>
         * Whether facet information can be returned for the field.
         * </p>
         * 
         * @param facetEnabled
         *        Whether facet information can be returned for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder facetEnabled(Boolean facetEnabled);

        /**
         * <p>
         * Whether the contents of the field are searchable.
         * </p>
         * 
         * @param searchEnabled
         *        Whether the contents of the field are searchable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder searchEnabled(Boolean searchEnabled);

        /**
         * <p>
         * Whether the contents of the field can be returned in the search results.
         * </p>
         * 
         * @param returnEnabled
         *        Whether the contents of the field can be returned in the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder returnEnabled(Boolean returnEnabled);

        /**
         * <p>
         * Whether the field can be used to sort the search results.
         * </p>
         * 
         * @param sortEnabled
         *        Whether the field can be used to sort the search results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortEnabled(Boolean sortEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String defaultValue;

        private String sourceField;

        private Boolean facetEnabled;

        private Boolean searchEnabled;

        private Boolean returnEnabled;

        private Boolean sortEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DateOptions model) {
            defaultValue(model.defaultValue);
            sourceField(model.sourceField);
            facetEnabled(model.facetEnabled);
            searchEnabled(model.searchEnabled);
            returnEnabled(model.returnEnabled);
            sortEnabled(model.sortEnabled);
        }

        public final String getDefaultValue() {
            return defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceField() {
            return sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final Boolean getFacetEnabled() {
            return facetEnabled;
        }

        @Override
        public final Builder facetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
            return this;
        }

        public final void setFacetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
        }

        public final Boolean getSearchEnabled() {
            return searchEnabled;
        }

        @Override
        public final Builder searchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public final void setSearchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
        }

        public final Boolean getReturnEnabled() {
            return returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public final Boolean getSortEnabled() {
            return sortEnabled;
        }

        @Override
        public final Builder sortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
            return this;
        }

        public final void setSortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
        }

        @Override
        public DateOptions build() {
            return new DateOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
