/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.cloudsearch.CloudSearchClient;
import software.amazon.awssdk.services.cloudsearch.model.BaseException;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.BuildSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchException;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchRequest;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.CreateDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DefineSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteAnalysisSchemeResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteDomainResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteExpressionResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteIndexFieldResponse;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAnalysisSchemesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeDomainsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeIndexFieldsResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersResponse;
import software.amazon.awssdk.services.cloudsearch.model.DisabledOperationException;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsRequest;
import software.amazon.awssdk.services.cloudsearch.model.IndexDocumentsResponse;
import software.amazon.awssdk.services.cloudsearch.model.InternalException;
import software.amazon.awssdk.services.cloudsearch.model.InvalidTypeException;
import software.amazon.awssdk.services.cloudsearch.model.LimitExceededException;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.cloudsearch.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.cloudsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateAvailabilityOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateDomainEndpointOptionsResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersResponse;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesRequest;
import software.amazon.awssdk.services.cloudsearch.model.UpdateServiceAccessPoliciesResponse;
import software.amazon.awssdk.services.cloudsearch.model.ValidationException;
import software.amazon.awssdk.services.cloudsearch.transform.BuildSuggestersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.CreateDomainRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineAnalysisSchemeRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineExpressionRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineIndexFieldRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DefineSuggesterRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteAnalysisSchemeRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteDomainRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteExpressionRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteIndexFieldRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DeleteSuggesterRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAnalysisSchemesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeAvailabilityOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeDomainEndpointOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeDomainsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeExpressionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeIndexFieldsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeScalingParametersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeServiceAccessPoliciesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DescribeSuggestersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.IndexDocumentsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateAvailabilityOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateDomainEndpointOptionsRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateScalingParametersRequestMarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.UpdateServiceAccessPoliciesRequestMarshaller;

@SdkInternalApi
final class DefaultCloudSearchClient
implements CloudSearchClient {
    private final SyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultCloudSearchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
    }

    public final String serviceName() {
        return "cloudsearch";
    }

    @Override
    public BuildSuggestersResponse buildSuggesters(BuildSuggestersRequest buildSuggestersRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(BuildSuggestersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (BuildSuggestersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("BuildSuggesters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)buildSuggestersRequest).withMarshaller((Marshaller)new BuildSuggestersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateDomainResponse createDomain(CreateDomainRequest createDomainRequest) throws BaseException, InternalException, LimitExceededException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(CreateDomainResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (CreateDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createDomainRequest).withMarshaller((Marshaller)new CreateDomainRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DefineAnalysisSchemeResponse defineAnalysisScheme(DefineAnalysisSchemeRequest defineAnalysisSchemeRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineAnalysisSchemeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DefineAnalysisSchemeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineAnalysisScheme").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineAnalysisSchemeRequest).withMarshaller((Marshaller)new DefineAnalysisSchemeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DefineExpressionResponse defineExpression(DefineExpressionRequest defineExpressionRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineExpressionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DefineExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineExpression").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineExpressionRequest).withMarshaller((Marshaller)new DefineExpressionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DefineIndexFieldResponse defineIndexField(DefineIndexFieldRequest defineIndexFieldRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineIndexFieldResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DefineIndexFieldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineIndexField").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineIndexFieldRequest).withMarshaller((Marshaller)new DefineIndexFieldRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DefineSuggesterResponse defineSuggester(DefineSuggesterRequest defineSuggesterRequest) throws BaseException, InternalException, LimitExceededException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DefineSuggesterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DefineSuggesterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DefineSuggester").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)defineSuggesterRequest).withMarshaller((Marshaller)new DefineSuggesterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteAnalysisSchemeResponse deleteAnalysisScheme(DeleteAnalysisSchemeRequest deleteAnalysisSchemeRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAnalysisSchemeResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteAnalysisSchemeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnalysisScheme").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAnalysisSchemeRequest).withMarshaller((Marshaller)new DeleteAnalysisSchemeRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteDomainResponse deleteDomain(DeleteDomainRequest deleteDomainRequest) throws BaseException, InternalException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDomainResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteDomainResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDomain").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteDomainRequest).withMarshaller((Marshaller)new DeleteDomainRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteExpressionResponse deleteExpression(DeleteExpressionRequest deleteExpressionRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteExpressionResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteExpressionResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteExpression").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteExpressionRequest).withMarshaller((Marshaller)new DeleteExpressionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteIndexFieldResponse deleteIndexField(DeleteIndexFieldRequest deleteIndexFieldRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteIndexFieldResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteIndexFieldResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteIndexField").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteIndexFieldRequest).withMarshaller((Marshaller)new DeleteIndexFieldRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteSuggesterResponse deleteSuggester(DeleteSuggesterRequest deleteSuggesterRequest) throws BaseException, InternalException, InvalidTypeException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteSuggesterResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DeleteSuggesterResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteSuggester").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteSuggesterRequest).withMarshaller((Marshaller)new DeleteSuggesterRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAnalysisSchemesResponse describeAnalysisSchemes(DescribeAnalysisSchemesRequest describeAnalysisSchemesRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAnalysisSchemesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAnalysisSchemesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnalysisSchemes").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAnalysisSchemesRequest).withMarshaller((Marshaller)new DescribeAnalysisSchemesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeAvailabilityOptionsResponse describeAvailabilityOptions(DescribeAvailabilityOptionsRequest describeAvailabilityOptionsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAvailabilityOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeAvailabilityOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAvailabilityOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeAvailabilityOptionsRequest).withMarshaller((Marshaller)new DescribeAvailabilityOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDomainEndpointOptionsResponse describeDomainEndpointOptions(DescribeDomainEndpointOptionsRequest describeDomainEndpointOptionsRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDomainEndpointOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDomainEndpointOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomainEndpointOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainEndpointOptionsRequest).withMarshaller((Marshaller)new DescribeDomainEndpointOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeDomainsResponse describeDomains(DescribeDomainsRequest describeDomainsRequest) throws BaseException, InternalException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeDomainsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeDomainsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeDomains").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeDomainsRequest).withMarshaller((Marshaller)new DescribeDomainsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeExpressionsResponse describeExpressions(DescribeExpressionsRequest describeExpressionsRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeExpressionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeExpressionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeExpressions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeExpressionsRequest).withMarshaller((Marshaller)new DescribeExpressionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeIndexFieldsResponse describeIndexFields(DescribeIndexFieldsRequest describeIndexFieldsRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeIndexFieldsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeIndexFieldsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeIndexFields").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeIndexFieldsRequest).withMarshaller((Marshaller)new DescribeIndexFieldsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeScalingParametersResponse describeScalingParameters(DescribeScalingParametersRequest describeScalingParametersRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeScalingParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeScalingParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeScalingParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeScalingParametersRequest).withMarshaller((Marshaller)new DescribeScalingParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeServiceAccessPoliciesResponse describeServiceAccessPolicies(DescribeServiceAccessPoliciesRequest describeServiceAccessPoliciesRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeServiceAccessPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeServiceAccessPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeServiceAccessPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeServiceAccessPoliciesRequest).withMarshaller((Marshaller)new DescribeServiceAccessPoliciesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeSuggestersResponse describeSuggesters(DescribeSuggestersRequest describeSuggestersRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeSuggestersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (DescribeSuggestersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeSuggesters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeSuggestersRequest).withMarshaller((Marshaller)new DescribeSuggestersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public IndexDocumentsResponse indexDocuments(IndexDocumentsRequest indexDocumentsRequest) throws BaseException, InternalException, ResourceNotFoundException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(IndexDocumentsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (IndexDocumentsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("IndexDocuments").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)indexDocumentsRequest).withMarshaller((Marshaller)new IndexDocumentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws BaseException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListDomainNamesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (ListDomainNamesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDomainNames").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listDomainNamesRequest).withMarshaller((Marshaller)new ListDomainNamesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateAvailabilityOptionsResponse updateAvailabilityOptions(UpdateAvailabilityOptionsRequest updateAvailabilityOptionsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateAvailabilityOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateAvailabilityOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateAvailabilityOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateAvailabilityOptionsRequest).withMarshaller((Marshaller)new UpdateAvailabilityOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateDomainEndpointOptionsResponse updateDomainEndpointOptions(UpdateDomainEndpointOptionsRequest updateDomainEndpointOptionsRequest) throws BaseException, InternalException, InvalidTypeException, LimitExceededException, ResourceNotFoundException, DisabledOperationException, ValidationException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateDomainEndpointOptionsResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateDomainEndpointOptionsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateDomainEndpointOptions").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateDomainEndpointOptionsRequest).withMarshaller((Marshaller)new UpdateDomainEndpointOptionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateScalingParametersResponse updateScalingParameters(UpdateScalingParametersRequest updateScalingParametersRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, InvalidTypeException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateScalingParametersResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateScalingParametersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateScalingParameters").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateScalingParametersRequest).withMarshaller((Marshaller)new UpdateScalingParametersRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateServiceAccessPoliciesResponse updateServiceAccessPolicies(UpdateServiceAccessPoliciesRequest updateServiceAccessPoliciesRequest) throws BaseException, InternalException, LimitExceededException, ResourceNotFoundException, InvalidTypeException, AwsServiceException, SdkClientException, CloudSearchException {
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UpdateServiceAccessPoliciesResponse::builder);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
        return (UpdateServiceAccessPoliciesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateServiceAccessPolicies").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateServiceAccessPoliciesRequest).withMarshaller((Marshaller)new UpdateServiceAccessPoliciesRequestMarshaller(this.protocolFactory)));
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("DisabledAction").exceptionBuilderSupplier(DisabledOperationException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidType").exceptionBuilderSupplier(InvalidTypeException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("BaseException").exceptionBuilderSupplier(BaseException::builder).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalException").exceptionBuilderSupplier(InternalException::builder).httpStatusCode(Integer.valueOf(500)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudSearchException::builder).build();
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends CloudSearchRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.30").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudSearchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

