/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of an <code>UpdateServiceAccessPolicies</code> request. Contains the new access policies.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateServiceAccessPoliciesResponse extends CloudSearchResponse implements
        ToCopyableBuilder<UpdateServiceAccessPoliciesResponse.Builder, UpdateServiceAccessPoliciesResponse> {
    private static final SdkField<AccessPoliciesStatus> ACCESS_POLICIES_FIELD = SdkField
            .<AccessPoliciesStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(UpdateServiceAccessPoliciesResponse::accessPolicies)).setter(setter(Builder::accessPolicies))
            .constructor(AccessPoliciesStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicies").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICIES_FIELD));

    private final AccessPoliciesStatus accessPolicies;

    private UpdateServiceAccessPoliciesResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicies = builder.accessPolicies;
    }

    /**
     * <p>
     * The access rules configured for the domain.
     * </p>
     * 
     * @return The access rules configured for the domain.
     */
    public AccessPoliciesStatus accessPolicies() {
        return accessPolicies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accessPolicies());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateServiceAccessPoliciesResponse)) {
            return false;
        }
        UpdateServiceAccessPoliciesResponse other = (UpdateServiceAccessPoliciesResponse) obj;
        return Objects.equals(accessPolicies(), other.accessPolicies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("UpdateServiceAccessPoliciesResponse").add("AccessPolicies", accessPolicies()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccessPolicies":
            return Optional.ofNullable(clazz.cast(accessPolicies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateServiceAccessPoliciesResponse, T> g) {
        return obj -> g.apply((UpdateServiceAccessPoliciesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateServiceAccessPoliciesResponse> {
        /**
         * <p>
         * The access rules configured for the domain.
         * </p>
         * 
         * @param accessPolicies
         *        The access rules configured for the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accessPolicies(AccessPoliciesStatus accessPolicies);

        /**
         * <p>
         * The access rules configured for the domain.
         * </p>
         * This is a convenience that creates an instance of the {@link AccessPoliciesStatus.Builder} avoiding the need
         * to create one manually via {@link AccessPoliciesStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccessPoliciesStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #accessPolicies(AccessPoliciesStatus)}.
         * 
         * @param accessPolicies
         *        a consumer that will call methods on {@link AccessPoliciesStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accessPolicies(AccessPoliciesStatus)
         */
        default Builder accessPolicies(Consumer<AccessPoliciesStatus.Builder> accessPolicies) {
            return accessPolicies(AccessPoliciesStatus.builder().applyMutation(accessPolicies).build());
        }
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private AccessPoliciesStatus accessPolicies;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateServiceAccessPoliciesResponse model) {
            super(model);
            accessPolicies(model.accessPolicies);
        }

        public final AccessPoliciesStatus.Builder getAccessPolicies() {
            return accessPolicies != null ? accessPolicies.toBuilder() : null;
        }

        @Override
        public final Builder accessPolicies(AccessPoliciesStatus accessPolicies) {
            this.accessPolicies = accessPolicies;
            return this;
        }

        public final void setAccessPolicies(AccessPoliciesStatus.BuilderImpl accessPolicies) {
            this.accessPolicies = accessPolicies != null ? accessPolicies.build() : null;
        }

        @Override
        public UpdateServiceAccessPoliciesResponse build() {
            return new UpdateServiceAccessPoliciesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
