/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DescribeSuggestersRequest;

public class DescribeSuggestersRequestMarshaller
implements Marshaller<Request<DescribeSuggestersRequest>, DescribeSuggestersRequest> {
    public Request<DescribeSuggestersRequest> marshall(DescribeSuggestersRequest describeSuggestersRequest) {
        List<String> suggesterNamesList;
        if (describeSuggestersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeSuggestersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeSuggesters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeSuggestersRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeSuggestersRequest.domainName()));
        }
        if ((suggesterNamesList = describeSuggestersRequest.suggesterNames()) != null) {
            if (!suggesterNamesList.isEmpty()) {
                int suggesterNamesListIndex = 1;
                for (String suggesterNamesListValue : suggesterNamesList) {
                    if (suggesterNamesListValue != null) {
                        request.addParameter("SuggesterNames.member." + suggesterNamesListIndex, StringUtils.fromString((String)suggesterNamesListValue));
                    }
                    ++suggesterNamesListIndex;
                }
            } else {
                request.addParameter("SuggesterNames", "");
            }
        }
        if (describeSuggestersRequest.deployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeSuggestersRequest.deployed()));
        }
        return request;
    }
}

