/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudsearchdomain.model.CloudSearchDomainRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.QueryParser;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class SearchRequest
extends CloudSearchDomainRequest
implements ToCopyableBuilder<Builder, SearchRequest> {
    private final String cursor;
    private final String expr;
    private final String facet;
    private final String filterQuery;
    private final String highlight;
    private final Boolean partial;
    private final String query;
    private final String queryOptions;
    private final String queryParser;
    private final Long size;
    private final String sort;
    private final Long start;
    private final String stats;
    private final String returnValues;

    private SearchRequest(BuilderImpl builder) {
        super(builder);
        this.cursor = builder.cursor;
        this.expr = builder.expr;
        this.facet = builder.facet;
        this.filterQuery = builder.filterQuery;
        this.highlight = builder.highlight;
        this.partial = builder.partial;
        this.query = builder.query;
        this.queryOptions = builder.queryOptions;
        this.queryParser = builder.queryParser;
        this.size = builder.size;
        this.sort = builder.sort;
        this.start = builder.start;
        this.stats = builder.stats;
        this.returnValues = builder.returnValues;
    }

    public String cursor() {
        return this.cursor;
    }

    public String expr() {
        return this.expr;
    }

    public String facet() {
        return this.facet;
    }

    public String filterQuery() {
        return this.filterQuery;
    }

    public String highlight() {
        return this.highlight;
    }

    public Boolean partial() {
        return this.partial;
    }

    public String query() {
        return this.query;
    }

    public String queryOptions() {
        return this.queryOptions;
    }

    public QueryParser queryParser() {
        return QueryParser.fromValue(this.queryParser);
    }

    public String queryParserString() {
        return this.queryParser;
    }

    public Long size() {
        return this.size;
    }

    public String sort() {
        return this.sort;
    }

    public Long start() {
        return this.start;
    }

    public String stats() {
        return this.stats;
    }

    public String returnValues() {
        return this.returnValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cursor());
        hashCode = 31 * hashCode + Objects.hashCode(this.expr());
        hashCode = 31 * hashCode + Objects.hashCode(this.facet());
        hashCode = 31 * hashCode + Objects.hashCode(this.filterQuery());
        hashCode = 31 * hashCode + Objects.hashCode(this.highlight());
        hashCode = 31 * hashCode + Objects.hashCode(this.partial());
        hashCode = 31 * hashCode + Objects.hashCode(this.query());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryParserString());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        hashCode = 31 * hashCode + Objects.hashCode(this.start());
        hashCode = 31 * hashCode + Objects.hashCode(this.stats());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnValues());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchRequest)) {
            return false;
        }
        SearchRequest other = (SearchRequest)((Object)obj);
        return Objects.equals(this.cursor(), other.cursor()) && Objects.equals(this.expr(), other.expr()) && Objects.equals(this.facet(), other.facet()) && Objects.equals(this.filterQuery(), other.filterQuery()) && Objects.equals(this.highlight(), other.highlight()) && Objects.equals(this.partial(), other.partial()) && Objects.equals(this.query(), other.query()) && Objects.equals(this.queryOptions(), other.queryOptions()) && Objects.equals(this.queryParserString(), other.queryParserString()) && Objects.equals(this.size(), other.size()) && Objects.equals(this.sort(), other.sort()) && Objects.equals(this.start(), other.start()) && Objects.equals(this.stats(), other.stats()) && Objects.equals(this.returnValues(), other.returnValues());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.cursor() != null) {
            sb.append("Cursor: ").append(this.cursor()).append(",");
        }
        if (this.expr() != null) {
            sb.append("Expr: ").append(this.expr()).append(",");
        }
        if (this.facet() != null) {
            sb.append("Facet: ").append(this.facet()).append(",");
        }
        if (this.filterQuery() != null) {
            sb.append("FilterQuery: ").append(this.filterQuery()).append(",");
        }
        if (this.highlight() != null) {
            sb.append("Highlight: ").append(this.highlight()).append(",");
        }
        if (this.partial() != null) {
            sb.append("Partial: ").append(this.partial()).append(",");
        }
        if (this.query() != null) {
            sb.append("Query: ").append(this.query()).append(",");
        }
        if (this.queryOptions() != null) {
            sb.append("QueryOptions: ").append(this.queryOptions()).append(",");
        }
        if (this.queryParserString() != null) {
            sb.append("QueryParser: ").append(this.queryParserString()).append(",");
        }
        if (this.size() != null) {
            sb.append("Size: ").append(this.size()).append(",");
        }
        if (this.sort() != null) {
            sb.append("Sort: ").append(this.sort()).append(",");
        }
        if (this.start() != null) {
            sb.append("Start: ").append(this.start()).append(",");
        }
        if (this.stats() != null) {
            sb.append("Stats: ").append(this.stats()).append(",");
        }
        if (this.returnValues() != null) {
            sb.append("ReturnValues: ").append(this.returnValues()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cursor": {
                return Optional.of(clazz.cast(this.cursor()));
            }
            case "expr": {
                return Optional.of(clazz.cast(this.expr()));
            }
            case "facet": {
                return Optional.of(clazz.cast(this.facet()));
            }
            case "filterQuery": {
                return Optional.of(clazz.cast(this.filterQuery()));
            }
            case "highlight": {
                return Optional.of(clazz.cast(this.highlight()));
            }
            case "partial": {
                return Optional.of(clazz.cast(this.partial()));
            }
            case "query": {
                return Optional.of(clazz.cast(this.query()));
            }
            case "queryOptions": {
                return Optional.of(clazz.cast(this.queryOptions()));
            }
            case "queryParser": {
                return Optional.of(clazz.cast(this.queryParserString()));
            }
            case "size": {
                return Optional.of(clazz.cast(this.size()));
            }
            case "sort": {
                return Optional.of(clazz.cast(this.sort()));
            }
            case "start": {
                return Optional.of(clazz.cast(this.start()));
            }
            case "stats": {
                return Optional.of(clazz.cast(this.stats()));
            }
            case "returnValues": {
                return Optional.of(clazz.cast(this.returnValues()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchDomainRequest.BuilderImpl
    implements Builder {
        private String cursor;
        private String expr;
        private String facet;
        private String filterQuery;
        private String highlight;
        private Boolean partial;
        private String query;
        private String queryOptions;
        private String queryParser;
        private Long size;
        private String sort;
        private Long start;
        private String stats;
        private String returnValues;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchRequest model) {
            this.cursor(model.cursor);
            this.expr(model.expr);
            this.facet(model.facet);
            this.filterQuery(model.filterQuery);
            this.highlight(model.highlight);
            this.partial(model.partial);
            this.query(model.query);
            this.queryOptions(model.queryOptions);
            this.queryParser(model.queryParser);
            this.size(model.size);
            this.sort(model.sort);
            this.start(model.start);
            this.stats(model.stats);
            this.returnValues(model.returnValues);
        }

        public final String getCursor() {
            return this.cursor;
        }

        @Override
        public final Builder cursor(String cursor) {
            this.cursor = cursor;
            return this;
        }

        public final void setCursor(String cursor) {
            this.cursor = cursor;
        }

        public final String getExpr() {
            return this.expr;
        }

        @Override
        public final Builder expr(String expr) {
            this.expr = expr;
            return this;
        }

        public final void setExpr(String expr) {
            this.expr = expr;
        }

        public final String getFacet() {
            return this.facet;
        }

        @Override
        public final Builder facet(String facet) {
            this.facet = facet;
            return this;
        }

        public final void setFacet(String facet) {
            this.facet = facet;
        }

        public final String getFilterQuery() {
            return this.filterQuery;
        }

        @Override
        public final Builder filterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
            return this;
        }

        public final void setFilterQuery(String filterQuery) {
            this.filterQuery = filterQuery;
        }

        public final String getHighlight() {
            return this.highlight;
        }

        @Override
        public final Builder highlight(String highlight) {
            this.highlight = highlight;
            return this;
        }

        public final void setHighlight(String highlight) {
            this.highlight = highlight;
        }

        public final Boolean getPartial() {
            return this.partial;
        }

        @Override
        public final Builder partial(Boolean partial) {
            this.partial = partial;
            return this;
        }

        public final void setPartial(Boolean partial) {
            this.partial = partial;
        }

        public final String getQuery() {
            return this.query;
        }

        @Override
        public final Builder query(String query) {
            this.query = query;
            return this;
        }

        public final void setQuery(String query) {
            this.query = query;
        }

        public final String getQueryOptions() {
            return this.queryOptions;
        }

        @Override
        public final Builder queryOptions(String queryOptions) {
            this.queryOptions = queryOptions;
            return this;
        }

        public final void setQueryOptions(String queryOptions) {
            this.queryOptions = queryOptions;
        }

        public final String getQueryParser() {
            return this.queryParser;
        }

        @Override
        public final Builder queryParser(String queryParser) {
            this.queryParser = queryParser;
            return this;
        }

        @Override
        public final Builder queryParser(QueryParser queryParser) {
            this.queryParser(queryParser.toString());
            return this;
        }

        public final void setQueryParser(String queryParser) {
            this.queryParser = queryParser;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public final String getSort() {
            return this.sort;
        }

        @Override
        public final Builder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public final void setSort(String sort) {
            this.sort = sort;
        }

        public final Long getStart() {
            return this.start;
        }

        @Override
        public final Builder start(Long start) {
            this.start = start;
            return this;
        }

        public final void setStart(Long start) {
            this.start = start;
        }

        public final String getStats() {
            return this.stats;
        }

        @Override
        public final Builder stats(String stats) {
            this.stats = stats;
            return this;
        }

        public final void setStats(String stats) {
            this.stats = stats;
        }

        public final String getReturnValues() {
            return this.returnValues;
        }

        @Override
        public final Builder returnValues(String returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        public final void setReturnValues(String returnValues) {
            this.returnValues = returnValues;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public SearchRequest build() {
            return new SearchRequest(this);
        }
    }

    public static interface Builder
    extends CloudSearchDomainRequest.Builder,
    CopyableBuilder<Builder, SearchRequest> {
        public Builder cursor(String var1);

        public Builder expr(String var1);

        public Builder facet(String var1);

        public Builder filterQuery(String var1);

        public Builder highlight(String var1);

        public Builder partial(Boolean var1);

        public Builder query(String var1);

        public Builder queryOptions(String var1);

        public Builder queryParser(String var1);

        public Builder queryParser(QueryParser var1);

        public Builder size(Long var1);

        public Builder sort(String var1);

        public Builder start(Long var1);

        public Builder stats(String var1);

        public Builder returnValues(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

