/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatus;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeDomainsResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeDomainsResponse> {
    private final List<DomainStatus> domainStatusList;

    private DescribeDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatusList = builder.domainStatusList;
    }

    public List<DomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainStatusList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainsResponse)) {
            return false;
        }
        DescribeDomainsResponse other = (DescribeDomainsResponse)((Object)obj);
        return Objects.equals(this.domainStatusList(), other.domainStatusList());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainStatusList() != null) {
            sb.append("DomainStatusList: ").append(this.domainStatusList()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainStatusList": {
                return Optional.of(clazz.cast(this.domainStatusList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<DomainStatus> domainStatusList;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainsResponse model) {
            this.domainStatusList(model.domainStatusList);
        }

        public final Collection<DomainStatus.Builder> getDomainStatusList() {
            return this.domainStatusList != null ? (Collection)this.domainStatusList.stream().map(DomainStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder domainStatusList(Collection<DomainStatus> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(DomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        public final void setDomainStatusList(Collection<DomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        @Override
        public DescribeDomainsResponse build() {
            return new DescribeDomainsResponse(this);
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    CopyableBuilder<Builder, DescribeDomainsResponse> {
        public Builder domainStatusList(Collection<DomainStatus> var1);

        public Builder domainStatusList(DomainStatus ... var1);
    }
}

