/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DeleteSuggesterRequest;

public class DeleteSuggesterRequestMarshaller
implements Marshaller<Request<DeleteSuggesterRequest>, DeleteSuggesterRequest> {
    public Request<DeleteSuggesterRequest> marshall(DeleteSuggesterRequest deleteSuggesterRequest) {
        if (deleteSuggesterRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)deleteSuggesterRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DeleteSuggester");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteSuggesterRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)deleteSuggesterRequest.domainName()));
        }
        if (deleteSuggesterRequest.suggesterName() != null) {
            request.addParameter("SuggesterName", StringUtils.fromString((String)deleteSuggesterRequest.suggesterName()));
        }
        return request;
    }
}

