/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Expression
implements ToCopyableBuilder<Builder, Expression> {
    private final String expressionName;
    private final String expressionValue;

    private Expression(BuilderImpl builder) {
        this.expressionName = builder.expressionName;
        this.expressionValue = builder.expressionValue;
    }

    public String expressionName() {
        return this.expressionName;
    }

    public String expressionValue() {
        return this.expressionValue;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.expressionValue());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Expression)) {
            return false;
        }
        Expression other = (Expression)obj;
        return Objects.equals(this.expressionName(), other.expressionName()) && Objects.equals(this.expressionValue(), other.expressionValue());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.expressionName() != null) {
            sb.append("ExpressionName: ").append(this.expressionName()).append(",");
        }
        if (this.expressionValue() != null) {
            sb.append("ExpressionValue: ").append(this.expressionValue()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExpressionName": {
                return Optional.of(clazz.cast(this.expressionName()));
            }
            case "ExpressionValue": {
                return Optional.of(clazz.cast(this.expressionValue()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String expressionName;
        private String expressionValue;

        private BuilderImpl() {
        }

        private BuilderImpl(Expression model) {
            this.expressionName(model.expressionName);
            this.expressionValue(model.expressionValue);
        }

        public final String getExpressionName() {
            return this.expressionName;
        }

        @Override
        public final Builder expressionName(String expressionName) {
            this.expressionName = expressionName;
            return this;
        }

        public final void setExpressionName(String expressionName) {
            this.expressionName = expressionName;
        }

        public final String getExpressionValue() {
            return this.expressionValue;
        }

        @Override
        public final Builder expressionValue(String expressionValue) {
            this.expressionValue = expressionValue;
            return this;
        }

        public final void setExpressionValue(String expressionValue) {
            this.expressionValue = expressionValue;
        }

        public Expression build() {
            return new Expression(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Expression> {
        public Builder expressionName(String var1);

        public Builder expressionValue(String var1);
    }
}

