/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.cloudsearch.model.ExpressionStatus;
import software.amazon.awssdk.services.cloudsearch.model.ExpressionStatusListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeExpressionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeExpressionsResponse> {
    private final List<ExpressionStatus> expressions;

    private DescribeExpressionsResponse(BuilderImpl builder) {
        this.expressions = builder.expressions;
    }

    public List<ExpressionStatus> expressions() {
        return this.expressions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expressions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExpressionsResponse)) {
            return false;
        }
        DescribeExpressionsResponse other = (DescribeExpressionsResponse)((Object)obj);
        return Objects.equals(this.expressions(), other.expressions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.expressions() != null) {
            sb.append("Expressions: ").append(this.expressions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expressions": {
                return Optional.of(clazz.cast(this.expressions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private List<ExpressionStatus> expressions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExpressionsResponse model) {
            this.expressions(model.expressions);
        }

        public final Collection<ExpressionStatus.Builder> getExpressions() {
            return this.expressions != null ? (Collection)this.expressions.stream().map(ExpressionStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder expressions(Collection<ExpressionStatus> expressions) {
            this.expressions = ExpressionStatusListCopier.copy(expressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder expressions(ExpressionStatus ... expressions) {
            this.expressions(Arrays.asList(expressions));
            return this;
        }

        public final void setExpressions(Collection<ExpressionStatus.BuilderImpl> expressions) {
            this.expressions = ExpressionStatusListCopier.copyFromBuilder(expressions);
        }

        public DescribeExpressionsResponse build() {
            return new DescribeExpressionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeExpressionsResponse> {
        public Builder expressions(Collection<ExpressionStatus> var1);

        public Builder expressions(ExpressionStatus ... var1);
    }
}

