/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DeleteAnalysisSchemeRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DeleteAnalysisSchemeRequest> {
    private final String domainName;
    private final String analysisSchemeName;

    private DeleteAnalysisSchemeRequest(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.analysisSchemeName = builder.analysisSchemeName;
    }

    public String domainName() {
        return this.domainName;
    }

    public String analysisSchemeName() {
        return this.analysisSchemeName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainName());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemeName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnalysisSchemeRequest)) {
            return false;
        }
        DeleteAnalysisSchemeRequest other = (DeleteAnalysisSchemeRequest)((Object)obj);
        return Objects.equals(this.domainName(), other.domainName()) && Objects.equals(this.analysisSchemeName(), other.analysisSchemeName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.domainName() != null) {
            sb.append("DomainName: ").append(this.domainName()).append(",");
        }
        if (this.analysisSchemeName() != null) {
            sb.append("AnalysisSchemeName: ").append(this.analysisSchemeName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainName": {
                return Optional.of(clazz.cast(this.domainName()));
            }
            case "AnalysisSchemeName": {
                return Optional.of(clazz.cast(this.analysisSchemeName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String domainName;
        private String analysisSchemeName;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnalysisSchemeRequest model) {
            this.domainName(model.domainName);
            this.analysisSchemeName(model.analysisSchemeName);
        }

        public final String getDomainName() {
            return this.domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final String getAnalysisSchemeName() {
            return this.analysisSchemeName;
        }

        @Override
        public final Builder analysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
            return this;
        }

        public final void setAnalysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
        }

        public DeleteAnalysisSchemeRequest build() {
            return new DeleteAnalysisSchemeRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DeleteAnalysisSchemeRequest> {
        public Builder domainName(String var1);

        public Builder analysisSchemeName(String var1);
    }
}

