/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.BucketInfo;

@SdkInternalApi
public class BucketInfoMarshaller {
    private static final MarshallingInfo<List> BUCKETS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("buckets").build();
    private static final BucketInfoMarshaller INSTANCE = new BucketInfoMarshaller();

    public static BucketInfoMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BucketInfo bucketInfo, ProtocolMarshaller protocolMarshaller) {
        if (bucketInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(bucketInfo.buckets(), BUCKETS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

