/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class TextOptions
implements ToCopyableBuilder<Builder, TextOptions> {
    private final String defaultValue;
    private final String sourceField;
    private final Boolean returnEnabled;
    private final Boolean sortEnabled;
    private final Boolean highlightEnabled;
    private final String analysisScheme;

    private TextOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceField = builder.sourceField;
        this.returnEnabled = builder.returnEnabled;
        this.sortEnabled = builder.sortEnabled;
        this.highlightEnabled = builder.highlightEnabled;
        this.analysisScheme = builder.analysisScheme;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String sourceField() {
        return this.sourceField;
    }

    public Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public Boolean sortEnabled() {
        return this.sortEnabled;
    }

    public Boolean highlightEnabled() {
        return this.highlightEnabled;
    }

    public String analysisScheme() {
        return this.analysisScheme;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.defaultValue() == null ? 0 : this.defaultValue().hashCode());
        hashCode = 31 * hashCode + (this.sourceField() == null ? 0 : this.sourceField().hashCode());
        hashCode = 31 * hashCode + (this.returnEnabled() == null ? 0 : this.returnEnabled().hashCode());
        hashCode = 31 * hashCode + (this.sortEnabled() == null ? 0 : this.sortEnabled().hashCode());
        hashCode = 31 * hashCode + (this.highlightEnabled() == null ? 0 : this.highlightEnabled().hashCode());
        hashCode = 31 * hashCode + (this.analysisScheme() == null ? 0 : this.analysisScheme().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextOptions)) {
            return false;
        }
        TextOptions other = (TextOptions)obj;
        if (other.defaultValue() == null ^ this.defaultValue() == null) {
            return false;
        }
        if (other.defaultValue() != null && !other.defaultValue().equals(this.defaultValue())) {
            return false;
        }
        if (other.sourceField() == null ^ this.sourceField() == null) {
            return false;
        }
        if (other.sourceField() != null && !other.sourceField().equals(this.sourceField())) {
            return false;
        }
        if (other.returnEnabled() == null ^ this.returnEnabled() == null) {
            return false;
        }
        if (other.returnEnabled() != null && !other.returnEnabled().equals(this.returnEnabled())) {
            return false;
        }
        if (other.sortEnabled() == null ^ this.sortEnabled() == null) {
            return false;
        }
        if (other.sortEnabled() != null && !other.sortEnabled().equals(this.sortEnabled())) {
            return false;
        }
        if (other.highlightEnabled() == null ^ this.highlightEnabled() == null) {
            return false;
        }
        if (other.highlightEnabled() != null && !other.highlightEnabled().equals(this.highlightEnabled())) {
            return false;
        }
        if (other.analysisScheme() == null ^ this.analysisScheme() == null) {
            return false;
        }
        return other.analysisScheme() == null || other.analysisScheme().equals(this.analysisScheme());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.sourceField() != null) {
            sb.append("SourceField: ").append(this.sourceField()).append(",");
        }
        if (this.returnEnabled() != null) {
            sb.append("ReturnEnabled: ").append(this.returnEnabled()).append(",");
        }
        if (this.sortEnabled() != null) {
            sb.append("SortEnabled: ").append(this.sortEnabled()).append(",");
        }
        if (this.highlightEnabled() != null) {
            sb.append("HighlightEnabled: ").append(this.highlightEnabled()).append(",");
        }
        if (this.analysisScheme() != null) {
            sb.append("AnalysisScheme: ").append(this.analysisScheme()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.of(clazz.cast(this.defaultValue()));
            }
            case "SourceField": {
                return Optional.of(clazz.cast(this.sourceField()));
            }
            case "ReturnEnabled": {
                return Optional.of(clazz.cast(this.returnEnabled()));
            }
            case "SortEnabled": {
                return Optional.of(clazz.cast(this.sortEnabled()));
            }
            case "HighlightEnabled": {
                return Optional.of(clazz.cast(this.highlightEnabled()));
            }
            case "AnalysisScheme": {
                return Optional.of(clazz.cast(this.analysisScheme()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String sourceField;
        private Boolean returnEnabled;
        private Boolean sortEnabled;
        private Boolean highlightEnabled;
        private String analysisScheme;

        private BuilderImpl() {
        }

        private BuilderImpl(TextOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceField(model.sourceField);
            this.returnEnabled(model.returnEnabled);
            this.sortEnabled(model.sortEnabled);
            this.highlightEnabled(model.highlightEnabled);
            this.analysisScheme(model.analysisScheme);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public final Boolean getSortEnabled() {
            return this.sortEnabled;
        }

        @Override
        public final Builder sortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
            return this;
        }

        public final void setSortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
        }

        public final Boolean getHighlightEnabled() {
            return this.highlightEnabled;
        }

        @Override
        public final Builder highlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
            return this;
        }

        public final void setHighlightEnabled(Boolean highlightEnabled) {
            this.highlightEnabled = highlightEnabled;
        }

        public final String getAnalysisScheme() {
            return this.analysisScheme;
        }

        @Override
        public final Builder analysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
            return this;
        }

        public final void setAnalysisScheme(String analysisScheme) {
            this.analysisScheme = analysisScheme;
        }

        public TextOptions build() {
            return new TextOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, TextOptions> {
        public Builder defaultValue(String var1);

        public Builder sourceField(String var1);

        public Builder returnEnabled(Boolean var1);

        public Builder sortEnabled(Boolean var1);

        public Builder highlightEnabled(Boolean var1);

        public Builder analysisScheme(String var1);
    }
}

